@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the managed application.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetApplicationPlainArgs(
    public val applicationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.GetApplicationPlainArgs =
        com.pulumi.azurenative.solutions.inputs.GetApplicationPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed application.
     */
    @JvmName("sternvvfhclldtre")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cgaopsdqfvsljajd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
