@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.GetJitRequestPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jitRequestName The name of the JIT request.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetJitRequestPlainArgs(
    public val jitRequestName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.GetJitRequestPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.GetJitRequestPlainArgs =
        com.pulumi.azurenative.solutions.inputs.GetJitRequestPlainArgs.builder()
            .jitRequestName(jitRequestName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJitRequestPlainArgs].
 */
@PulumiTagMarker
public class GetJitRequestPlainArgsBuilder internal constructor() {
    private var jitRequestName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the JIT request.
     */
    @JvmName("rgdffhvcbvjaalue")
    public suspend fun jitRequestName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jitRequestName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vsdxckvroulwelpx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJitRequestPlainArgs = GetJitRequestPlainArgs(
        jitRequestName = jitRequestName ?: throw PulumiNullFieldException("jitRequestName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
