@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed application artifact.
 * @property name The managed application artifact name.
 * @property type The managed application artifact type.
 * @property uri The managed application artifact blob uri.
 */
public data class ApplicationArtifactResponse(
    public val name: String,
    public val type: String,
    public val uri: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationArtifactResponse):
            ApplicationArtifactResponse = ApplicationArtifactResponse(
            name = javaType.name(),
            type = javaType.type(),
            uri = javaType.uri(),
        )
    }
}
