@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Managed application notification policy.
 * @property notificationEndpoints The managed application notification endpoint.
 */
public data class ApplicationNotificationPolicyResponse(
    public val notificationEndpoints: List<ApplicationNotificationEndpointResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationNotificationPolicyResponse):
            ApplicationNotificationPolicyResponse = ApplicationNotificationPolicyResponse(
            notificationEndpoints = javaType.notificationEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationNotificationEndpointResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
