@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The JIT scheduling policies.
 * @property duration
 * @property startTime The start time of the request.
 * @property type The type of JIT schedule.
 */
public data class JitSchedulingPolicyResponse(
    public val duration: String,
    public val startTime: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.JitSchedulingPolicyResponse):
            JitSchedulingPolicyResponse = JitSchedulingPolicyResponse(
            duration = javaType.duration(),
            startTime = javaType.startTime(),
            type = javaType.type(),
        )
    }
}
