@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU for the resource.
 * @property capacity The SKU capacity.
 * @property family The SKU family.
 * @property model The SKU model.
 * @property name The SKU name.
 * @property size The SKU size.
 * @property tier The SKU tier.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val model: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
                family = javaType.family().map({ args0 -> args0 }).orElse(null),
                model = javaType.model().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                size = javaType.size().map({ args0 -> args0 }).orElse(null),
                tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
