@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents the user assigned identity that is contained within the UserAssignedIdentities dictionary on ResourceIdentity
 * @property principalId The principal id of user assigned identity.
 * @property tenantId The tenant id of user assigned identity.
 */
public data class UserAssignedResourceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.UserAssignedResourceIdentityResponse):
            UserAssignedResourceIdentityResponse = UserAssignedResourceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
        )
    }
}
