@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SecurityAlertsPolicyState
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A database security alert policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2018-06-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update a database's threat detection policy with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSecurityAlertPolicy = new AzureNative.Sql.DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DisabledAlerts = new[]
 *         {
 *             "Sql_Injection",
 *             "Usage_Anomaly",
 *         },
 *         EmailAccountAdmins = true,
 *         EmailAddresses = new[]
 *         {
 *             "test@microsoft.com",
 *             "user@microsoft.com",
 *         },
 *         ResourceGroupName = "securityalert-4799",
 *         RetentionDays = 6,
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = AzureNative.Sql.SecurityAlertsPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSecurityAlertPolicy(ctx, "databaseSecurityAlertPolicy", &sql.DatabaseSecurityAlertPolicyArgs{
 * 			DatabaseName: pulumi.String("testdb"),
 * 			DisabledAlerts: pulumi.StringArray{
 * 				pulumi.String("Sql_Injection"),
 * 				pulumi.String("Usage_Anomaly"),
 * 			},
 * 			EmailAccountAdmins: pulumi.Bool(true),
 * 			EmailAddresses: pulumi.StringArray{
 * 				pulumi.String("test@microsoft.com"),
 * 				pulumi.String("user@microsoft.com"),
 * 			},
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			RetentionDays:           pulumi.Int(6),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   sql.SecurityAlertsPolicyStateEnabled,
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSecurityAlertPolicy = new DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", DatabaseSecurityAlertPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .disabledAlerts(
 *                 "Sql_Injection",
 *                 "Usage_Anomaly")
 *             .emailAccountAdmins(true)
 *             .emailAddresses(
 *                 "test@microsoft.com",
 *                 "user@microsoft.com")
 *             .resourceGroupName("securityalert-4799")
 *             .retentionDays(6)
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a database's threat detection policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSecurityAlertPolicy = new AzureNative.Sql.DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securityalert-4799",
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = AzureNative.Sql.SecurityAlertsPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSecurityAlertPolicy(ctx, "databaseSecurityAlertPolicy", &sql.DatabaseSecurityAlertPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   sql.SecurityAlertsPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSecurityAlertPolicy = new DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", DatabaseSecurityAlertPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securityalert-4799")
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseSecurityAlertPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}
 * ```
 * @property databaseName The name of the  database for which the security alert policy is defined.
 * @property disabledAlerts Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
 * @property emailAccountAdmins Specifies that the alert is sent to the account administrators.
 * @property emailAddresses Specifies an array of e-mail addresses to which the alert is sent.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property retentionDays Specifies the number of days to keep in the Threat Detection audit logs.
 * @property securityAlertPolicyName The name of the security alert policy.
 * @property serverName The name of the  server.
 * @property state Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
 * @property storageAccountAccessKey Specifies the identifier key of the Threat Detection audit storage account.
 * @property storageEndpoint Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
 */
public data class DatabaseSecurityAlertPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val disabledAlerts: Output<List<String>>? = null,
    public val emailAccountAdmins: Output<Boolean>? = null,
    public val emailAddresses: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val securityAlertPolicyName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val state: Output<SecurityAlertsPolicyState>? = null,
    public val storageAccountAccessKey: Output<String>? = null,
    public val storageEndpoint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs =
        com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .disabledAlerts(disabledAlerts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .emailAccountAdmins(emailAccountAdmins?.applyValue({ args0 -> args0 }))
            .emailAddresses(emailAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .securityAlertPolicyName(securityAlertPolicyName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountAccessKey(storageAccountAccessKey?.applyValue({ args0 -> args0 }))
            .storageEndpoint(storageEndpoint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatabaseSecurityAlertPolicyArgs].
 */
@PulumiTagMarker
public class DatabaseSecurityAlertPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var disabledAlerts: Output<List<String>>? = null

    private var emailAccountAdmins: Output<Boolean>? = null

    private var emailAddresses: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var securityAlertPolicyName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var state: Output<SecurityAlertsPolicyState>? = null

    private var storageAccountAccessKey: Output<String>? = null

    private var storageEndpoint: Output<String>? = null

    /**
     * @param value The name of the  database for which the security alert policy is defined.
     */
    @JvmName("uqyaxyrlyyuljsmq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
     */
    @JvmName("lnofbtpargllkwyw")
    public suspend fun disabledAlerts(`value`: Output<List<String>>) {
        this.disabledAlerts = value
    }

    @JvmName("psheasrpifeacpxw")
    public suspend fun disabledAlerts(vararg values: Output<String>) {
        this.disabledAlerts = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
     */
    @JvmName("vwiqugguokrdprjm")
    public suspend fun disabledAlerts(values: List<Output<String>>) {
        this.disabledAlerts = Output.all(values)
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("wsdydtuykxeupfmi")
    public suspend fun emailAccountAdmins(`value`: Output<Boolean>) {
        this.emailAccountAdmins = value
    }

    /**
     * @param value Specifies an array of e-mail addresses to which the alert is sent.
     */
    @JvmName("bcndihqijmobbflj")
    public suspend fun emailAddresses(`value`: Output<List<String>>) {
        this.emailAddresses = value
    }

    @JvmName("iajesdatdtcygdpx")
    public suspend fun emailAddresses(vararg values: Output<String>) {
        this.emailAddresses = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array of e-mail addresses to which the alert is sent.
     */
    @JvmName("hmhmlrxokhaotcow")
    public suspend fun emailAddresses(values: List<Output<String>>) {
        this.emailAddresses = Output.all(values)
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("iuoeckupnkxfoyxf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies the number of days to keep in the Threat Detection audit logs.
     */
    @JvmName("nxixgjblttorsdot")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("gshyplqqtxciltla")
    public suspend fun securityAlertPolicyName(`value`: Output<String>) {
        this.securityAlertPolicyName = value
    }

    /**
     * @param value The name of the  server.
     */
    @JvmName("mcjqokhtiwwdkxyw")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
     */
    @JvmName("ptleyonbuyjejshy")
    public suspend fun state(`value`: Output<SecurityAlertsPolicyState>) {
        this.state = value
    }

    /**
     * @param value Specifies the identifier key of the Threat Detection audit storage account.
     */
    @JvmName("buslcjydsvtcvohw")
    public suspend fun storageAccountAccessKey(`value`: Output<String>) {
        this.storageAccountAccessKey = value
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
     */
    @JvmName("mgrnbjakfsjmaoek")
    public suspend fun storageEndpoint(`value`: Output<String>) {
        this.storageEndpoint = value
    }

    /**
     * @param value The name of the  database for which the security alert policy is defined.
     */
    @JvmName("rhxavqvoupqtumsj")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
     */
    @JvmName("ydahevqrfwiofrgy")
    public suspend fun disabledAlerts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledAlerts = mapped
    }

    /**
     * @param values Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
     */
    @JvmName("rxobdwbtwbeavnbt")
    public suspend fun disabledAlerts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledAlerts = mapped
    }

    /**
     * @param value Specifies that the alert is sent to the account administrators.
     */
    @JvmName("mjervnioufdklogf")
    public suspend fun emailAccountAdmins(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAccountAdmins = mapped
    }

    /**
     * @param value Specifies an array of e-mail addresses to which the alert is sent.
     */
    @JvmName("btpgbpeehvktigmw")
    public suspend fun emailAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param values Specifies an array of e-mail addresses to which the alert is sent.
     */
    @JvmName("gcrbopbvsjphxefi")
    public suspend fun emailAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emailAddresses = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lanmoinfibestweg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies the number of days to keep in the Threat Detection audit logs.
     */
    @JvmName("nrtlvsbsikwltwhi")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The name of the security alert policy.
     */
    @JvmName("vebimamomyqsmnru")
    public suspend fun securityAlertPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityAlertPolicyName = mapped
    }

    /**
     * @param value The name of the  server.
     */
    @JvmName("epvsmlxbbcfexpbw")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
     */
    @JvmName("xqrqthidqpaujeys")
    public suspend fun state(`value`: SecurityAlertsPolicyState?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Specifies the identifier key of the Threat Detection audit storage account.
     */
    @JvmName("nfqohxqtbcxdvoau")
    public suspend fun storageAccountAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountAccessKey = mapped
    }

    /**
     * @param value Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
     */
    @JvmName("muhoxdyntrjpkbdr")
    public suspend fun storageEndpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEndpoint = mapped
    }

    internal fun build(): DatabaseSecurityAlertPolicyArgs = DatabaseSecurityAlertPolicyArgs(
        databaseName = databaseName,
        disabledAlerts = disabledAlerts,
        emailAccountAdmins = emailAccountAdmins,
        emailAddresses = emailAddresses,
        resourceGroupName = resourceGroupName,
        retentionDays = retentionDays,
        securityAlertPolicyName = securityAlertPolicyName,
        serverName = serverName,
        state = state,
        storageAccountAccessKey = storageAccountAccessKey,
        storageEndpoint = storageEndpoint,
    )
}
