@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a disaster recovery configuration.
 * Azure REST API version: 2014-04-01. Prior API version in Azure Native 1.x: 2014-04-01.
 * ## Example Usage
 * ### Update a disaster recovery configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disasterRecoveryConfiguration = new AzureNative.Sql.DisasterRecoveryConfiguration("disasterRecoveryConfiguration", new()
 *     {
 *         DisasterRecoveryConfigurationName = "Default",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-5961",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDisasterRecoveryConfiguration(ctx, "disasterRecoveryConfiguration", &sql.DisasterRecoveryConfigurationArgs{
 * 			DisasterRecoveryConfigurationName: pulumi.String("Default"),
 * 			ResourceGroupName:                 pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:                        pulumi.String("sqlcrudtest-5961"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DisasterRecoveryConfiguration;
 * import com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disasterRecoveryConfiguration = new DisasterRecoveryConfiguration("disasterRecoveryConfiguration", DisasterRecoveryConfigurationArgs.builder()
 *             .disasterRecoveryConfigurationName("Default")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-5961")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DisasterRecoveryConfiguration Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/disasterRecoveryConfiguration/{disasterRecoveryConfigurationName}
 * ```
 * @property disasterRecoveryConfigurationName The name of the disaster recovery configuration to be created/updated.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class DisasterRecoveryConfigurationArgs(
    public val disasterRecoveryConfigurationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs =
        com.pulumi.azurenative.sql.DisasterRecoveryConfigurationArgs.builder()
            .disasterRecoveryConfigurationName(
                disasterRecoveryConfigurationName?.applyValue({ args0 ->
                    args0
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DisasterRecoveryConfigurationArgs].
 */
@PulumiTagMarker
public class DisasterRecoveryConfigurationArgsBuilder internal constructor() {
    private var disasterRecoveryConfigurationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the disaster recovery configuration to be created/updated.
     */
    @JvmName("jmedxjrytfyokuvc")
    public suspend fun disasterRecoveryConfigurationName(`value`: Output<String>) {
        this.disasterRecoveryConfigurationName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("domkdqljtkulesjx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("cbtneisvgfnbhyfh")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the disaster recovery configuration to be created/updated.
     */
    @JvmName("dymgtlhhklefblkq")
    public suspend fun disasterRecoveryConfigurationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disasterRecoveryConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ttexcljmolftsjao")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("kyipfqwcacutlqtf")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): DisasterRecoveryConfigurationArgs = DisasterRecoveryConfigurationArgs(
        disasterRecoveryConfigurationName = disasterRecoveryConfigurationName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
