@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ExtendedDatabaseBlobAuditingPolicy].
 */
@PulumiTagMarker
public class ExtendedDatabaseBlobAuditingPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtendedDatabaseBlobAuditingPolicyArgs = ExtendedDatabaseBlobAuditingPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtendedDatabaseBlobAuditingPolicyArgsBuilder.() -> Unit) {
        val builder = ExtendedDatabaseBlobAuditingPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ExtendedDatabaseBlobAuditingPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ExtendedDatabaseBlobAuditingPolicy(builtJavaResource)
    }
}

/**
 * An extended database blob auditing policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update an extended database's azure monitor auditing policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extendedDatabaseBlobAuditingPolicy = new AzureNative.Sql.ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", new()
 *     {
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         IsAzureMonitorTargetEnabled = true,
 *         ResourceGroupName = "blobauditingtest-4799",
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewExtendedDatabaseBlobAuditingPolicy(ctx, "extendedDatabaseBlobAuditingPolicy", &sql.ExtendedDatabaseBlobAuditingPolicyArgs{
 * 			BlobAuditingPolicyName:      pulumi.String("default"),
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			IsAzureMonitorTargetEnabled: pulumi.Bool(true),
 * 			ResourceGroupName:           pulumi.String("blobauditingtest-4799"),
 * 			ServerName:                  pulumi.String("blobauditingtest-6440"),
 * 			State:                       sql.BlobAuditingPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedDatabaseBlobAuditingPolicy = new ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", ExtendedDatabaseBlobAuditingPolicyArgs.builder()
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .isAzureMonitorTargetEnabled(true)
 *             .resourceGroupName("blobauditingtest-4799")
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an extended database's blob auditing policy with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extendedDatabaseBlobAuditingPolicy = new AzureNative.Sql.ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", new()
 *     {
 *         AuditActionsAndGroups = new[]
 *         {
 *             "DATABASE_LOGOUT_GROUP",
 *             "DATABASE_ROLE_MEMBER_CHANGE_GROUP",
 *             "UPDATE on database::TestDatabaseName by public",
 *         },
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         IsAzureMonitorTargetEnabled = true,
 *         IsStorageSecondaryKeyInUse = false,
 *         PredicateExpression = "statement = 'select 1'",
 *         QueueDelayMs = 4000,
 *         ResourceGroupName = "blobauditingtest-4799",
 *         RetentionDays = 6,
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageAccountSubscriptionId = "00000000-1234-0000-5678-000000000000",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewExtendedDatabaseBlobAuditingPolicy(ctx, "extendedDatabaseBlobAuditingPolicy", &sql.ExtendedDatabaseBlobAuditingPolicyArgs{
 * 			AuditActionsAndGroups: pulumi.StringArray{
 * 				pulumi.String("DATABASE_LOGOUT_GROUP"),
 * 				pulumi.String("DATABASE_ROLE_MEMBER_CHANGE_GROUP"),
 * 				pulumi.String("UPDATE on database::TestDatabaseName by public"),
 * 			},
 * 			BlobAuditingPolicyName:       pulumi.String("default"),
 * 			DatabaseName:                 pulumi.String("testdb"),
 * 			IsAzureMonitorTargetEnabled:  pulumi.Bool(true),
 * 			IsStorageSecondaryKeyInUse:   pulumi.Bool(false),
 * 			PredicateExpression:          pulumi.String("statement = 'select 1'"),
 * 			QueueDelayMs:                 pulumi.Int(4000),
 * 			ResourceGroupName:            pulumi.String("blobauditingtest-4799"),
 * 			RetentionDays:                pulumi.Int(6),
 * 			ServerName:                   pulumi.String("blobauditingtest-6440"),
 * 			State:                        sql.BlobAuditingPolicyStateEnabled,
 * 			StorageAccountAccessKey:      pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageAccountSubscriptionId: pulumi.String("00000000-1234-0000-5678-000000000000"),
 * 			StorageEndpoint:              pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedDatabaseBlobAuditingPolicy = new ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", ExtendedDatabaseBlobAuditingPolicyArgs.builder()
 *             .auditActionsAndGroups(
 *                 "DATABASE_LOGOUT_GROUP",
 *                 "DATABASE_ROLE_MEMBER_CHANGE_GROUP",
 *                 "UPDATE on database::TestDatabaseName by public")
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .isAzureMonitorTargetEnabled(true)
 *             .isStorageSecondaryKeyInUse(false)
 *             .predicateExpression("statement = 'select 1'")
 *             .queueDelayMs(4000)
 *             .resourceGroupName("blobauditingtest-4799")
 *             .retentionDays(6)
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageAccountSubscriptionId("00000000-1234-0000-5678-000000000000")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update an extended database's blob auditing policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extendedDatabaseBlobAuditingPolicy = new AzureNative.Sql.ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", new()
 *     {
 *         BlobAuditingPolicyName = "default",
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "blobauditingtest-4799",
 *         ServerName = "blobauditingtest-6440",
 *         State = AzureNative.Sql.BlobAuditingPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewExtendedDatabaseBlobAuditingPolicy(ctx, "extendedDatabaseBlobAuditingPolicy", &sql.ExtendedDatabaseBlobAuditingPolicyArgs{
 * 			BlobAuditingPolicyName:  pulumi.String("default"),
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("blobauditingtest-4799"),
 * 			ServerName:              pulumi.String("blobauditingtest-6440"),
 * 			State:                   sql.BlobAuditingPolicyStateEnabled,
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy;
 * import com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extendedDatabaseBlobAuditingPolicy = new ExtendedDatabaseBlobAuditingPolicy("extendedDatabaseBlobAuditingPolicy", ExtendedDatabaseBlobAuditingPolicyArgs.builder()
 *             .blobAuditingPolicyName("default")
 *             .databaseName("testdb")
 *             .resourceGroupName("blobauditingtest-4799")
 *             .serverName("blobauditingtest-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ExtendedDatabaseBlobAuditingPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/extendedAuditingSettings/{blobAuditingPolicyName}
 * ```
 */
public class ExtendedDatabaseBlobAuditingPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy,
) : KotlinCustomResource(javaResource, ExtendedDatabaseBlobAuditingPolicyMapper) {
    /**
     * Specifies the Actions-Groups and Actions to audit.
     * The recommended set of action groups to use is the following combination - this will audit all the queries and stored procedures executed against the database, as well as successful and failed logins:
     * BATCH_COMPLETED_GROUP,
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     * FAILED_DATABASE_AUTHENTICATION_GROUP.
     * This above combination is also the set that is configured by default when enabling auditing from the Azure portal.
     * The supported action groups to audit are (note: choose only specific groups that cover your auditing needs. Using unnecessary groups could lead to very large quantities of audit records):
     * APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     * BACKUP_RESTORE_GROUP
     * DATABASE_LOGOUT_GROUP
     * DATABASE_OBJECT_CHANGE_GROUP
     * DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     * DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     * DATABASE_OPERATION_GROUP
     * DATABASE_PERMISSION_CHANGE_GROUP
     * DATABASE_PRINCIPAL_CHANGE_GROUP
     * DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     * DATABASE_ROLE_MEMBER_CHANGE_GROUP
     * FAILED_DATABASE_AUTHENTICATION_GROUP
     * SCHEMA_OBJECT_ACCESS_GROUP
     * SCHEMA_OBJECT_CHANGE_GROUP
     * SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     * SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     * SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     * USER_CHANGE_PASSWORD_GROUP
     * BATCH_STARTED_GROUP
     * BATCH_COMPLETED_GROUP
     * DBCC_GROUP
     * DATABASE_OWNERSHIP_CHANGE_GROUP
     * DATABASE_CHANGE_GROUP
     * LEDGER_OPERATION_GROUP
     * These are groups that cover all sql statements and stored procedures executed against the database, and should not be used in combination with other groups as this will result in duplicate audit logs.
     * For more information, see [Database-Level Audit Action Groups](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups).
     * For Database auditing policy, specific Actions can also be specified (note that Actions cannot be specified for Server auditing policy). The supported actions to audit are:
     * SELECT
     * UPDATE
     * INSERT
     * DELETE
     * EXECUTE
     * RECEIVE
     * REFERENCES
     * The general form for defining an action to be audited is:
     * {action} ON {object} BY {principal}
     * Note that <object> in the above format can refer to an object like a table, view, or stored procedure, or an entire database or schema. For the latter cases, the forms DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.
     * For example:
     * SELECT on dbo.myTable by public
     * SELECT on DATABASE::myDatabase by public
     * SELECT on SCHEMA::mySchema by public
     * For more information, see [Database-Level Audit Actions](https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions)
     */
    public val auditActionsAndGroups: Output<List<String>>?
        get() = javaResource.auditActionsAndGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies whether audit events are sent to Azure Monitor.
     * In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and 'IsAzureMonitorTargetEnabled' as true.
     * When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents' diagnostic logs category on the database should be also created.
     * Note that for server level audit you should use the 'master' database as {databaseName}.
     * Diagnostic Settings URI format:
     * PUT https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview
     * For more information, see [Diagnostic Settings REST API](https://go.microsoft.com/fwlink/?linkid=2033207)
     * or [Diagnostic Settings PowerShell](https://go.microsoft.com/fwlink/?linkid=2033043)
     */
    public val isAzureMonitorTargetEnabled: Output<Boolean>?
        get() = javaResource.isAzureMonitorTargetEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether Managed Identity is used to access blob storage
     */
    public val isManagedIdentityInUse: Output<Boolean>?
        get() = javaResource.isManagedIdentityInUse().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies whether storageAccountAccessKey value is the storage's secondary key.
     */
    public val isStorageSecondaryKeyInUse: Output<Boolean>?
        get() = javaResource.isStorageSecondaryKeyInUse().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies condition of where clause when creating an audit.
     */
    public val predicateExpression: Output<String>?
        get() = javaResource.predicateExpression().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the amount of time in milliseconds that can elapse before audit actions are forced to be processed.
     * The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
     */
    public val queueDelayMs: Output<Int>?
        get() = javaResource.queueDelayMs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the number of days to keep in the audit logs in the storage account.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the state of the audit. If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled are required.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Specifies the blob storage subscription Id.
     */
    public val storageAccountSubscriptionId: Output<String>?
        get() = javaResource.storageAccountSubscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or isAzureMonitorTargetEnabled is required.
     */
    public val storageEndpoint: Output<String>?
        get() = javaResource.storageEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExtendedDatabaseBlobAuditingPolicyMapper :
    ResourceMapper<ExtendedDatabaseBlobAuditingPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy::class == javaResource::class

    override fun map(javaResource: Resource): ExtendedDatabaseBlobAuditingPolicy =
        ExtendedDatabaseBlobAuditingPolicy(
            javaResource as
                com.pulumi.azurenative.sql.ExtendedDatabaseBlobAuditingPolicy,
        )
}

/**
 * @see [ExtendedDatabaseBlobAuditingPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExtendedDatabaseBlobAuditingPolicy].
 */
public suspend fun extendedDatabaseBlobAuditingPolicy(
    name: String,
    block: suspend ExtendedDatabaseBlobAuditingPolicyResourceBuilder.() -> Unit,
):
    ExtendedDatabaseBlobAuditingPolicy {
    val builder = ExtendedDatabaseBlobAuditingPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExtendedDatabaseBlobAuditingPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extendedDatabaseBlobAuditingPolicy(name: String): ExtendedDatabaseBlobAuditingPolicy {
    val builder = ExtendedDatabaseBlobAuditingPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
