@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.FailoverGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.FailoverGroupReadOnlyEndpointArgs
import com.pulumi.azurenative.sql.kotlin.inputs.FailoverGroupReadOnlyEndpointArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.FailoverGroupReadWriteEndpointArgs
import com.pulumi.azurenative.sql.kotlin.inputs.FailoverGroupReadWriteEndpointArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.PartnerInfoArgs
import com.pulumi.azurenative.sql.kotlin.inputs.PartnerInfoArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A failover group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create failover group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var failoverGroup = new AzureNative.Sql.FailoverGroup("failoverGroup", new()
 *     {
 *         Databases = new[]
 *         {
 *             "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1",
 *             "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2",
 *         },
 *         FailoverGroupName = "failover-group-test-3",
 *         PartnerServers = new[]
 *         {
 *             new AzureNative.Sql.Inputs.PartnerInfoArgs
 *             {
 *                 Id = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server",
 *             },
 *         },
 *         ReadOnlyEndpoint = new AzureNative.Sql.Inputs.FailoverGroupReadOnlyEndpointArgs
 *         {
 *             FailoverPolicy = "Disabled",
 *         },
 *         ReadWriteEndpoint = new AzureNative.Sql.Inputs.FailoverGroupReadWriteEndpointArgs
 *         {
 *             FailoverPolicy = "Automatic",
 *             FailoverWithDataLossGracePeriodMinutes = 480,
 *         },
 *         ResourceGroupName = "Default",
 *         ServerName = "failover-group-primary-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFailoverGroup(ctx, "failoverGroup", &sql.FailoverGroupArgs{
 * 			Databases: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1"),
 * 				pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2"),
 * 			},
 * 			FailoverGroupName: pulumi.String("failover-group-test-3"),
 * 			PartnerServers: []sql.PartnerInfoArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server"),
 * 				},
 * 			},
 * 			ReadOnlyEndpoint: &sql.FailoverGroupReadOnlyEndpointArgs{
 * 				FailoverPolicy: pulumi.String("Disabled"),
 * 			},
 * 			ReadWriteEndpoint: &sql.FailoverGroupReadWriteEndpointArgs{
 * 				FailoverPolicy:                         pulumi.String("Automatic"),
 * 				FailoverWithDataLossGracePeriodMinutes: pulumi.Int(480),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("failover-group-primary-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FailoverGroup;
 * import com.pulumi.azurenative.sql.FailoverGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var failoverGroup = new FailoverGroup("failoverGroup", FailoverGroupArgs.builder()
 *             .databases(
 *                 "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1",
 *                 "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2")
 *             .failoverGroupName("failover-group-test-3")
 *             .partnerServers(Map.of("id", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server"))
 *             .readOnlyEndpoint(Map.of("failoverPolicy", "Disabled"))
 *             .readWriteEndpoint(Map.ofEntries(
 *                 Map.entry("failoverPolicy", "Automatic"),
 *                 Map.entry("failoverWithDataLossGracePeriodMinutes", 480)
 *             ))
 *             .resourceGroupName("Default")
 *             .serverName("failover-group-primary-server")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:FailoverGroup failover-group-test-3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}
 * ```
 * @property databases List of databases in the failover group.
 * @property failoverGroupName The name of the failover group.
 * @property partnerServers List of partner server information for the failover group.
 * @property readOnlyEndpoint Read-only endpoint of the failover group instance.
 * @property readWriteEndpoint Read-write endpoint of the failover group instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server containing the failover group.
 * @property tags Resource tags.
 */
public data class FailoverGroupArgs(
    public val databases: Output<List<String>>? = null,
    public val failoverGroupName: Output<String>? = null,
    public val partnerServers: Output<List<PartnerInfoArgs>>? = null,
    public val readOnlyEndpoint: Output<FailoverGroupReadOnlyEndpointArgs>? = null,
    public val readWriteEndpoint: Output<FailoverGroupReadWriteEndpointArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.FailoverGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.FailoverGroupArgs =
        com.pulumi.azurenative.sql.FailoverGroupArgs.builder()
            .databases(databases?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .failoverGroupName(failoverGroupName?.applyValue({ args0 -> args0 }))
            .partnerServers(
                partnerServers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .readOnlyEndpoint(readOnlyEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readWriteEndpoint(readWriteEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FailoverGroupArgs].
 */
@PulumiTagMarker
public class FailoverGroupArgsBuilder internal constructor() {
    private var databases: Output<List<String>>? = null

    private var failoverGroupName: Output<String>? = null

    private var partnerServers: Output<List<PartnerInfoArgs>>? = null

    private var readOnlyEndpoint: Output<FailoverGroupReadOnlyEndpointArgs>? = null

    private var readWriteEndpoint: Output<FailoverGroupReadWriteEndpointArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value List of databases in the failover group.
     */
    @JvmName("cktaldphhqnxjkfj")
    public suspend fun databases(`value`: Output<List<String>>) {
        this.databases = value
    }

    @JvmName("etghdjqrqobqxjws")
    public suspend fun databases(vararg values: Output<String>) {
        this.databases = Output.all(values.asList())
    }

    /**
     * @param values List of databases in the failover group.
     */
    @JvmName("affwcwmeawhvlkrk")
    public suspend fun databases(values: List<Output<String>>) {
        this.databases = Output.all(values)
    }

    /**
     * @param value The name of the failover group.
     */
    @JvmName("enwiwckybaivmfrx")
    public suspend fun failoverGroupName(`value`: Output<String>) {
        this.failoverGroupName = value
    }

    /**
     * @param value List of partner server information for the failover group.
     */
    @JvmName("bhnjefdlvpcfovfh")
    public suspend fun partnerServers(`value`: Output<List<PartnerInfoArgs>>) {
        this.partnerServers = value
    }

    @JvmName("gednwkcvuqsoihco")
    public suspend fun partnerServers(vararg values: Output<PartnerInfoArgs>) {
        this.partnerServers = Output.all(values.asList())
    }

    /**
     * @param values List of partner server information for the failover group.
     */
    @JvmName("pnrlpxpvxoonjoot")
    public suspend fun partnerServers(values: List<Output<PartnerInfoArgs>>) {
        this.partnerServers = Output.all(values)
    }

    /**
     * @param value Read-only endpoint of the failover group instance.
     */
    @JvmName("bvdvierrupifjseu")
    public suspend fun readOnlyEndpoint(`value`: Output<FailoverGroupReadOnlyEndpointArgs>) {
        this.readOnlyEndpoint = value
    }

    /**
     * @param value Read-write endpoint of the failover group instance.
     */
    @JvmName("prvpjeiahvkecwib")
    public suspend fun readWriteEndpoint(`value`: Output<FailoverGroupReadWriteEndpointArgs>) {
        this.readWriteEndpoint = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qxslrmlvshqsrxff")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server containing the failover group.
     */
    @JvmName("gankyliqybglixrf")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("ebmyyeuwappugoug")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value List of databases in the failover group.
     */
    @JvmName("fjxsiuufwaenjwje")
    public suspend fun databases(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param values List of databases in the failover group.
     */
    @JvmName("kpjdlgxdlknhqahx")
    public suspend fun databases(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databases = mapped
    }

    /**
     * @param value The name of the failover group.
     */
    @JvmName("ufeenubevlwxdnce")
    public suspend fun failoverGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverGroupName = mapped
    }

    /**
     * @param value List of partner server information for the failover group.
     */
    @JvmName("mnrvgphfbrgfpinj")
    public suspend fun partnerServers(`value`: List<PartnerInfoArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerServers = mapped
    }

    /**
     * @param argument List of partner server information for the failover group.
     */
    @JvmName("umampucxsjfcxbqu")
    public suspend fun partnerServers(argument: List<suspend PartnerInfoArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { PartnerInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.partnerServers = mapped
    }

    /**
     * @param argument List of partner server information for the failover group.
     */
    @JvmName("nxlkisupwbmomxyi")
    public suspend fun partnerServers(vararg argument: suspend PartnerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { PartnerInfoArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.partnerServers = mapped
    }

    /**
     * @param argument List of partner server information for the failover group.
     */
    @JvmName("tuuebvxeruotrmct")
    public suspend fun partnerServers(argument: suspend PartnerInfoArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PartnerInfoArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.partnerServers = mapped
    }

    /**
     * @param values List of partner server information for the failover group.
     */
    @JvmName("ljlbnjfowhkhbaka")
    public suspend fun partnerServers(vararg values: PartnerInfoArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerServers = mapped
    }

    /**
     * @param value Read-only endpoint of the failover group instance.
     */
    @JvmName("jlqdbdilpinoffjj")
    public suspend fun readOnlyEndpoint(`value`: FailoverGroupReadOnlyEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnlyEndpoint = mapped
    }

    /**
     * @param argument Read-only endpoint of the failover group instance.
     */
    @JvmName("unthvjegiwfodaeq")
    public suspend
    fun readOnlyEndpoint(argument: suspend FailoverGroupReadOnlyEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = FailoverGroupReadOnlyEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readOnlyEndpoint = mapped
    }

    /**
     * @param value Read-write endpoint of the failover group instance.
     */
    @JvmName("fybeyltgpthnldvr")
    public suspend fun readWriteEndpoint(`value`: FailoverGroupReadWriteEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readWriteEndpoint = mapped
    }

    /**
     * @param argument Read-write endpoint of the failover group instance.
     */
    @JvmName("cidbxoofvnjmendj")
    public suspend
    fun readWriteEndpoint(argument: suspend FailoverGroupReadWriteEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = FailoverGroupReadWriteEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.readWriteEndpoint = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xuknxexeshwaqfej")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server containing the failover group.
     */
    @JvmName("cipdlpovulrlbner")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("npisntovoucchnyf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nphlinqdqyhejiam")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FailoverGroupArgs = FailoverGroupArgs(
        databases = databases,
        failoverGroupName = failoverGroupName,
        partnerServers = partnerServers,
        readOnlyEndpoint = readOnlyEndpoint,
        readWriteEndpoint = readWriteEndpoint,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        tags = tags,
    )
}
