@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A server firewall rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.Sql.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "0.0.0.3",
 *         FirewallRuleName = "firewallrulecrudtest-5370",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIpAddress = "0.0.0.3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFirewallRule(ctx, "firewallRule", &sql.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("0.0.0.3"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-5370"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIpAddress:    pulumi.String("0.0.0.3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FirewallRule;
 * import com.pulumi.azurenative.sql.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("0.0.0.3")
 *             .firewallRuleName("firewallrulecrudtest-5370")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIpAddress("0.0.0.3")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.Sql.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "0.0.0.1",
 *         FirewallRuleName = "firewallrulecrudtest-3927",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIpAddress = "0.0.0.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFirewallRule(ctx, "firewallRule", &sql.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("0.0.0.1"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-3927"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIpAddress:    pulumi.String("0.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FirewallRule;
 * import com.pulumi.azurenative.sql.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("0.0.0.1")
 *             .firewallRuleName("firewallrulecrudtest-3927")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIpAddress("0.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:FirewallRule firewallrulecrudtest-3927 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}
 * ```
 * @property endIpAddress The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP addresses.
 * @property firewallRuleName The name of the firewall rule.
 * @property name Resource name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property startIpAddress The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
 */
public data class FirewallRuleArgs(
    public val endIpAddress: Output<String>? = null,
    public val firewallRuleName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.FirewallRuleArgs =
        com.pulumi.azurenative.sql.FirewallRuleArgs.builder()
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var firewallRuleName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    @JvmName("ugiqmhsknwfjhprc")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("sndojtigcworegym")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("dvlpcdniixlaamgk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uvlpnvlksdsjnacu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ookpyfseixphdxhr")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    @JvmName("nuoxgmpcqjhmbnim")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    @JvmName("bowrnquawvyplvwv")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("yxlfitfmkthebfuk")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("nhpviahbntbledfi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eojofdyvpgftrxqy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("iaxsnfqhsfmantyo")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    @JvmName("drrpqcdecwpnnphk")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        endIpAddress = endIpAddress,
        firewallRuleName = firewallRuleName,
        name = name,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        startIpAddress = startIpAddress,
    )
}
