@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [IPv6FirewallRule].
 */
@PulumiTagMarker
public class IPv6FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IPv6FirewallRuleArgs = IPv6FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IPv6FirewallRuleArgsBuilder.() -> Unit) {
        val builder = IPv6FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): IPv6FirewallRule {
        val builtJavaResource = com.pulumi.azurenative.sql.IPv6FirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IPv6FirewallRule(builtJavaResource)
    }
}

/**
 * An IPv6 server firewall rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create an IPv6 firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iPv6FirewallRule = new AzureNative.Sql.IPv6FirewallRule("iPv6FirewallRule", new()
 *     {
 *         EndIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0003",
 *         FirewallRuleName = "firewallrulecrudtest-5370",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0003",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewIPv6FirewallRule(ctx, "iPv6FirewallRule", &sql.IPv6FirewallRuleArgs{
 * 			EndIPv6Address:    pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0003"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-5370"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIPv6Address:  pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0003"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.IPv6FirewallRule;
 * import com.pulumi.azurenative.sql.IPv6FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iPv6FirewallRule = new IPv6FirewallRule("iPv6FirewallRule", IPv6FirewallRuleArgs.builder()
 *             .endIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0003")
 *             .firewallRuleName("firewallrulecrudtest-5370")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0003")
 *             .build());
 *     }
 * }
 * ```
 * ### Update an IPv6 firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iPv6FirewallRule = new AzureNative.Sql.IPv6FirewallRule("iPv6FirewallRule", new()
 *     {
 *         EndIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0001",
 *         FirewallRuleName = "firewallrulecrudtest-3927",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0001",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewIPv6FirewallRule(ctx, "iPv6FirewallRule", &sql.IPv6FirewallRuleArgs{
 * 			EndIPv6Address:    pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0001"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-3927"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIPv6Address:  pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0001"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.IPv6FirewallRule;
 * import com.pulumi.azurenative.sql.IPv6FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iPv6FirewallRule = new IPv6FirewallRule("iPv6FirewallRule", IPv6FirewallRuleArgs.builder()
 *             .endIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0001")
 *             .firewallRuleName("firewallrulecrudtest-3927")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0001")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:IPv6FirewallRule firewallrulecrudtest-3927 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/ipv6FirewallRules/{firewallRuleName}
 * ```
 */
public class IPv6FirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.IPv6FirewallRule,
) : KotlinCustomResource(javaResource, IPv6FirewallRuleMapper) {
    /**
     * The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
     */
    public val endIPv6Address: Output<String>?
        get() = javaResource.endIPv6Address().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The start IP address of the firewall rule. Must be IPv6 format.
     */
    public val startIPv6Address: Output<String>?
        get() = javaResource.startIPv6Address().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IPv6FirewallRuleMapper : ResourceMapper<IPv6FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.IPv6FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): IPv6FirewallRule = IPv6FirewallRule(
        javaResource as
            com.pulumi.azurenative.sql.IPv6FirewallRule,
    )
}

/**
 * @see [IPv6FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IPv6FirewallRule].
 */
public suspend fun iPv6FirewallRule(
    name: String,
    block: suspend IPv6FirewallRuleResourceBuilder.() -> Unit,
): IPv6FirewallRule {
    val builder = IPv6FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IPv6FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iPv6FirewallRule(name: String): IPv6FirewallRule {
    val builder = IPv6FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
