@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.IPv6FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An IPv6 server firewall rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-08-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create an IPv6 firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iPv6FirewallRule = new AzureNative.Sql.IPv6FirewallRule("iPv6FirewallRule", new()
 *     {
 *         EndIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0003",
 *         FirewallRuleName = "firewallrulecrudtest-5370",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0003",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewIPv6FirewallRule(ctx, "iPv6FirewallRule", &sql.IPv6FirewallRuleArgs{
 * 			EndIPv6Address:    pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0003"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-5370"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIPv6Address:  pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0003"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.IPv6FirewallRule;
 * import com.pulumi.azurenative.sql.IPv6FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iPv6FirewallRule = new IPv6FirewallRule("iPv6FirewallRule", IPv6FirewallRuleArgs.builder()
 *             .endIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0003")
 *             .firewallRuleName("firewallrulecrudtest-5370")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0003")
 *             .build());
 *     }
 * }
 * ```
 * ### Update an IPv6 firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iPv6FirewallRule = new AzureNative.Sql.IPv6FirewallRule("iPv6FirewallRule", new()
 *     {
 *         EndIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0001",
 *         FirewallRuleName = "firewallrulecrudtest-3927",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIPv6Address = "0000:0000:0000:0000:0000:ffff:0000:0001",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewIPv6FirewallRule(ctx, "iPv6FirewallRule", &sql.IPv6FirewallRuleArgs{
 * 			EndIPv6Address:    pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0001"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-3927"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIPv6Address:  pulumi.String("0000:0000:0000:0000:0000:ffff:0000:0001"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.IPv6FirewallRule;
 * import com.pulumi.azurenative.sql.IPv6FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iPv6FirewallRule = new IPv6FirewallRule("iPv6FirewallRule", IPv6FirewallRuleArgs.builder()
 *             .endIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0001")
 *             .firewallRuleName("firewallrulecrudtest-3927")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIPv6Address("0000:0000:0000:0000:0000:ffff:0000:0001")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:IPv6FirewallRule firewallrulecrudtest-3927 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/ipv6FirewallRules/{firewallRuleName}
 * ```
 * @property endIPv6Address The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
 * @property firewallRuleName The name of the firewall rule.
 * @property name Resource name.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property startIPv6Address The start IP address of the firewall rule. Must be IPv6 format.
 */
public data class IPv6FirewallRuleArgs(
    public val endIPv6Address: Output<String>? = null,
    public val firewallRuleName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val startIPv6Address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.IPv6FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.IPv6FirewallRuleArgs =
        com.pulumi.azurenative.sql.IPv6FirewallRuleArgs.builder()
            .endIPv6Address(endIPv6Address?.applyValue({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .startIPv6Address(startIPv6Address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPv6FirewallRuleArgs].
 */
@PulumiTagMarker
public class IPv6FirewallRuleArgsBuilder internal constructor() {
    private var endIPv6Address: Output<String>? = null

    private var firewallRuleName: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var startIPv6Address: Output<String>? = null

    /**
     * @param value The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
     */
    @JvmName("waflfhpcpoyqafxc")
    public suspend fun endIPv6Address(`value`: Output<String>) {
        this.endIPv6Address = value
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("tambmqhxaarxludd")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("govovobbrfyuwhui")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("trquhbfehlrlqytb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("wadhrlxxhgfvqldn")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv6 format.
     */
    @JvmName("fvumcyvbdnxqpbjx")
    public suspend fun startIPv6Address(`value`: Output<String>) {
        this.startIPv6Address = value
    }

    /**
     * @param value The end IP address of the firewall rule. Must be IPv6 format. Must be greater than or equal to startIpAddress.
     */
    @JvmName("fydvnsvlqpyctaoc")
    public suspend fun endIPv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIPv6Address = mapped
    }

    /**
     * @param value The name of the firewall rule.
     */
    @JvmName("njmdnfbjaddtisuo")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value Resource name.
     */
    @JvmName("eylyyanjoloemhep")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("chchvkhjwgrvutba")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("rhtpcffghertlkmx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The start IP address of the firewall rule. Must be IPv6 format.
     */
    @JvmName("fdljlpnxsvwmbxva")
    public suspend fun startIPv6Address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIPv6Address = mapped
    }

    internal fun build(): IPv6FirewallRuleArgs = IPv6FirewallRuleArgs(
        endIPv6Address = endIPv6Address,
        firewallRuleName = firewallRuleName,
        name = name,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        startIPv6Address = startIPv6Address,
    )
}
