@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [InstancePool].
 */
@PulumiTagMarker
public class InstancePoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstancePoolArgs = InstancePoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstancePoolArgsBuilder.() -> Unit) {
        val builder = InstancePoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InstancePool {
        val builtJavaResource = com.pulumi.azurenative.sql.InstancePool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InstancePool(builtJavaResource)
    }
}

/**
 * An Azure SQL instance pool.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create an instance pool with all properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancePool = new AzureNative.Sql.InstancePool("instancePool", new()
 *     {
 *         InstancePoolName = "testIP",
 *         LicenseType = "LicenseIncluded",
 *         Location = "japaneast",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Family = "Gen5",
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         SubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstancePool(ctx, "instancePool", &sql.InstancePoolArgs{
 * 			InstancePoolName:  pulumi.String("testIP"),
 * 			LicenseType:       pulumi.String("LicenseIncluded"),
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &sql.SkuArgs{
 * 				Family: pulumi.String("Gen5"),
 * 				Name:   pulumi.String("GP_Gen5"),
 * 				Tier:   pulumi.String("GeneralPurpose"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 			VCores: pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstancePool;
 * import com.pulumi.azurenative.sql.InstancePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instancePool = new InstancePool("instancePool", InstancePoolArgs.builder()
 *             .instancePoolName("testIP")
 *             .licenseType("LicenseIncluded")
 *             .location("japaneast")
 *             .resourceGroupName("group1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .subnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1")
 *             .tags(Map.of("a", "b"))
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ### Create an instance pool with min properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancePool = new AzureNative.Sql.InstancePool("instancePool", new()
 *     {
 *         InstancePoolName = "testIP",
 *         LicenseType = "LicenseIncluded",
 *         Location = "japaneast",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Family = "Gen5",
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         SubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstancePool(ctx, "instancePool", &sql.InstancePoolArgs{
 * 			InstancePoolName:  pulumi.String("testIP"),
 * 			LicenseType:       pulumi.String("LicenseIncluded"),
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &sql.SkuArgs{
 * 				Family: pulumi.String("Gen5"),
 * 				Name:   pulumi.String("GP_Gen5"),
 * 				Tier:   pulumi.String("GeneralPurpose"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1"),
 * 			VCores:   pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstancePool;
 * import com.pulumi.azurenative.sql.InstancePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instancePool = new InstancePool("instancePool", InstancePoolArgs.builder()
 *             .instancePoolName("testIP")
 *             .licenseType("LicenseIncluded")
 *             .location("japaneast")
 *             .resourceGroupName("group1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .subnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:InstancePool testIP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}
 * ```
 */
public class InstancePool internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.InstancePool,
) : KotlinCustomResource(javaResource, InstancePoolMapper) {
    /**
     * The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
     */
    public val licenseType: Output<String>
        get() = javaResource.licenseType().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name and tier of the SKU.
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource ID of the subnet to place this instance pool in.
     */
    public val subnetId: Output<String>
        get() = javaResource.subnetId().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Count of vCores belonging to this instance pool.
     */
    public val vCores: Output<Int>
        get() = javaResource.vCores().applyValue({ args0 -> args0 })
}

public object InstancePoolMapper : ResourceMapper<InstancePool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.InstancePool::class == javaResource::class

    override fun map(javaResource: Resource): InstancePool = InstancePool(
        javaResource as
            com.pulumi.azurenative.sql.InstancePool,
    )
}

/**
 * @see [InstancePool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstancePool].
 */
public suspend fun instancePool(
    name: String,
    block: suspend InstancePoolResourceBuilder.() -> Unit,
): InstancePool {
    val builder = InstancePoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstancePool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instancePool(name: String): InstancePool {
    val builder = InstancePoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
