@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobStepArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepActionArgs
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepActionArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepExecutionOptionsArgs
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepExecutionOptionsArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepOutputArgs
import com.pulumi.azurenative.sql.kotlin.inputs.JobStepOutputArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A job step.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a job step with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobStep = new AzureNative.Sql.JobStep("jobStep", new()
 *     {
 *         Action = new AzureNative.Sql.Inputs.JobStepActionArgs
 *         {
 *             Source = "Inline",
 *             Type = "TSql",
 *             Value = "select 2",
 *         },
 *         Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1",
 *         ExecutionOptions = new AzureNative.Sql.Inputs.JobStepExecutionOptionsArgs
 *         {
 *             InitialRetryIntervalSeconds = 11,
 *             MaximumRetryIntervalSeconds = 222,
 *             RetryAttempts = 42,
 *             RetryIntervalBackoffMultiplier = 3,
 *             TimeoutSeconds = 1234,
 *         },
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         Output = new AzureNative.Sql.Inputs.JobStepOutputArgs
 *         {
 *             Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0",
 *             DatabaseName = "database3",
 *             ResourceGroupName = "group3",
 *             SchemaName = "myschema1234",
 *             ServerName = "server3",
 *             SubscriptionId = "3501b905-a848-4b5d-96e8-b253f62d735a",
 *             TableName = "mytable5678",
 *             Type = "SqlDatabase",
 *         },
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         StepId = 1,
 *         StepName = "step1",
 *         TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobStep(ctx, "jobStep", &sql.JobStepArgs{
 * 			Action: &sql.JobStepActionArgs{
 * 				Source: pulumi.String("Inline"),
 * 				Type:   pulumi.String("TSql"),
 * 				Value:  pulumi.String("select 2"),
 * 			},
 * 			Credential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1"),
 * 			ExecutionOptions: &sql.JobStepExecutionOptionsArgs{
 * 				InitialRetryIntervalSeconds:    pulumi.Int(11),
 * 				MaximumRetryIntervalSeconds:    pulumi.Int(222),
 * 				RetryAttempts:                  pulumi.Int(42),
 * 				RetryIntervalBackoffMultiplier: pulumi.Float64(3),
 * 				TimeoutSeconds:                 pulumi.Int(1234),
 * 			},
 * 			JobAgentName: pulumi.String("agent1"),
 * 			JobName:      pulumi.String("job1"),
 * 			Output: &sql.JobStepOutputTypeArgs{
 * 				Credential:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 * 				DatabaseName:      pulumi.String("database3"),
 * 				ResourceGroupName: pulumi.String("group3"),
 * 				SchemaName:        pulumi.String("myschema1234"),
 * 				ServerName:        pulumi.String("server3"),
 * 				SubscriptionId:    pulumi.String("3501b905-a848-4b5d-96e8-b253f62d735a"),
 * 				TableName:         pulumi.String("mytable5678"),
 * 				Type:              pulumi.String("SqlDatabase"),
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			StepId:            pulumi.Int(1),
 * 			StepName:          pulumi.String("step1"),
 * 			TargetGroup:       pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobStep;
 * import com.pulumi.azurenative.sql.JobStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobStep = new JobStep("jobStep", JobStepArgs.builder()
 *             .action(Map.ofEntries(
 *                 Map.entry("source", "Inline"),
 *                 Map.entry("type", "TSql"),
 *                 Map.entry("value", "select 2")
 *             ))
 *             .credential("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1")
 *             .executionOptions(Map.ofEntries(
 *                 Map.entry("initialRetryIntervalSeconds", 11),
 *                 Map.entry("maximumRetryIntervalSeconds", 222),
 *                 Map.entry("retryAttempts", 42),
 *                 Map.entry("retryIntervalBackoffMultiplier", 3),
 *                 Map.entry("timeoutSeconds", 1234)
 *             ))
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .output(Map.ofEntries(
 *                 Map.entry("credential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 *                 Map.entry("databaseName", "database3"),
 *                 Map.entry("resourceGroupName", "group3"),
 *                 Map.entry("schemaName", "myschema1234"),
 *                 Map.entry("serverName", "server3"),
 *                 Map.entry("subscriptionId", "3501b905-a848-4b5d-96e8-b253f62d735a"),
 *                 Map.entry("tableName", "mytable5678"),
 *                 Map.entry("type", "SqlDatabase")
 *             ))
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .stepId(1)
 *             .stepName("step1")
 *             .targetGroup("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a job step with minimal properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobStep = new AzureNative.Sql.JobStep("jobStep", new()
 *     {
 *         Action = new AzureNative.Sql.Inputs.JobStepActionArgs
 *         {
 *             Value = "select 1",
 *         },
 *         Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0",
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         StepName = "step1",
 *         TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobStep(ctx, "jobStep", &sql.JobStepArgs{
 * 			Action: &sql.JobStepActionArgs{
 * 				Value: pulumi.String("select 1"),
 * 			},
 * 			Credential:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			StepName:          pulumi.String("step1"),
 * 			TargetGroup:       pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobStep;
 * import com.pulumi.azurenative.sql.JobStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobStep = new JobStep("jobStep", JobStepArgs.builder()
 *             .action(Map.of("value", "select 1"))
 *             .credential("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0")
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .stepName("step1")
 *             .targetGroup("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobStep step1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}
 * ```
 * @property action The action payload of the job step.
 * @property credential The resource ID of the job credential that will be used to connect to the targets.
 * @property executionOptions Execution options for the job step.
 * @property jobAgentName The name of the job agent.
 * @property jobName The name of the job.
 * @property output Output destination properties of the job step.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property stepId The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
 * @property stepName The name of the job step.
 * @property targetGroup The resource ID of the target group that the job step will be executed on.
 */
public data class JobStepArgs(
    public val action: Output<JobStepActionArgs>? = null,
    public val credential: Output<String>? = null,
    public val executionOptions: Output<JobStepExecutionOptionsArgs>? = null,
    public val jobAgentName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val output: Output<JobStepOutputArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val stepId: Output<Int>? = null,
    public val stepName: Output<String>? = null,
    public val targetGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobStepArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobStepArgs =
        com.pulumi.azurenative.sql.JobStepArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0 }))
            .executionOptions(executionOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .output(output?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .stepId(stepId?.applyValue({ args0 -> args0 }))
            .stepName(stepName?.applyValue({ args0 -> args0 }))
            .targetGroup(targetGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobStepArgs].
 */
@PulumiTagMarker
public class JobStepArgsBuilder internal constructor() {
    private var action: Output<JobStepActionArgs>? = null

    private var credential: Output<String>? = null

    private var executionOptions: Output<JobStepExecutionOptionsArgs>? = null

    private var jobAgentName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var output: Output<JobStepOutputArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var stepId: Output<Int>? = null

    private var stepName: Output<String>? = null

    private var targetGroup: Output<String>? = null

    /**
     * @param value The action payload of the job step.
     */
    @JvmName("esncqttmtudfsrrt")
    public suspend fun action(`value`: Output<JobStepActionArgs>) {
        this.action = value
    }

    /**
     * @param value The resource ID of the job credential that will be used to connect to the targets.
     */
    @JvmName("nwfuejnikaebvsil")
    public suspend fun credential(`value`: Output<String>) {
        this.credential = value
    }

    /**
     * @param value Execution options for the job step.
     */
    @JvmName("grcdnmwggoolhfkj")
    public suspend fun executionOptions(`value`: Output<JobStepExecutionOptionsArgs>) {
        this.executionOptions = value
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("svlsqujxnxmymtnm")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value The name of the job.
     */
    @JvmName("qjrdbrfbvaimduwe")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value Output destination properties of the job step.
     */
    @JvmName("nfbhuivabwtirjar")
    public suspend fun output(`value`: Output<JobStepOutputArgs>) {
        this.output = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uvtlnoafowxleyvv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("vjrmrnrkvedwowte")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
     */
    @JvmName("wmewnrkmgmokiknh")
    public suspend fun stepId(`value`: Output<Int>) {
        this.stepId = value
    }

    /**
     * @param value The name of the job step.
     */
    @JvmName("lsbbsxctsxgyctna")
    public suspend fun stepName(`value`: Output<String>) {
        this.stepName = value
    }

    /**
     * @param value The resource ID of the target group that the job step will be executed on.
     */
    @JvmName("lordeuiscseysefu")
    public suspend fun targetGroup(`value`: Output<String>) {
        this.targetGroup = value
    }

    /**
     * @param value The action payload of the job step.
     */
    @JvmName("hkgwgoursgoxqmtj")
    public suspend fun action(`value`: JobStepActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action payload of the job step.
     */
    @JvmName("ykicvsuaqielfkhm")
    public suspend fun action(argument: suspend JobStepActionArgsBuilder.() -> Unit) {
        val toBeMapped = JobStepActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The resource ID of the job credential that will be used to connect to the targets.
     */
    @JvmName("ccmlokjgogxxmqhq")
    public suspend fun credential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param value Execution options for the job step.
     */
    @JvmName("bbemhqfonlasxmfp")
    public suspend fun executionOptions(`value`: JobStepExecutionOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionOptions = mapped
    }

    /**
     * @param argument Execution options for the job step.
     */
    @JvmName("ysnehfwtmubxdeyq")
    public suspend
    fun executionOptions(argument: suspend JobStepExecutionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = JobStepExecutionOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.executionOptions = mapped
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("rjuogskenlysuhnj")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the job.
     */
    @JvmName("xestclvhlkdkmvlq")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value Output destination properties of the job step.
     */
    @JvmName("eccqxkolnxmqinnq")
    public suspend fun output(`value`: JobStepOutputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.output = mapped
    }

    /**
     * @param argument Output destination properties of the job step.
     */
    @JvmName("jamlqbecabantggx")
    public suspend fun output(argument: suspend JobStepOutputArgsBuilder.() -> Unit) {
        val toBeMapped = JobStepOutputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.output = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gpdkadsxlxevtuji")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ciyojdtqyptqvwfa")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
     */
    @JvmName("lqbvxlwjwgamhjpm")
    public suspend fun stepId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepId = mapped
    }

    /**
     * @param value The name of the job step.
     */
    @JvmName("wkkelkmqrncgjvav")
    public suspend fun stepName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepName = mapped
    }

    /**
     * @param value The resource ID of the target group that the job step will be executed on.
     */
    @JvmName("ddklxesqgsacwlng")
    public suspend fun targetGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroup = mapped
    }

    internal fun build(): JobStepArgs = JobStepArgs(
        action = action,
        credential = credential,
        executionOptions = executionOptions,
        jobAgentName = jobAgentName,
        jobName = jobName,
        output = output,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        stepId = stepId,
        stepName = stepName,
        targetGroup = targetGroup,
    )
}
