@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.JobTargetResponse
import com.pulumi.azurenative.sql.kotlin.outputs.JobTargetResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [JobTargetGroup].
 */
@PulumiTagMarker
public class JobTargetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobTargetGroupArgs = JobTargetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobTargetGroupArgsBuilder.() -> Unit) {
        val builder = JobTargetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobTargetGroup {
        val builtJavaResource = com.pulumi.azurenative.sql.JobTargetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobTargetGroup(builtJavaResource)
    }
}

/**
 * A group of job targets.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a target group with all properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobTargetGroup = new AzureNative.Sql.JobTargetGroup("jobTargetGroup", new()
 *     {
 *         JobAgentName = "agent1",
 *         Members = new[]
 *         {
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 DatabaseName = "database1",
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Exclude,
 *                 ServerName = "server1",
 *                 Type = "SqlDatabase",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server1",
 *                 Type = "SqlServer",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 ElasticPoolName = "pool1",
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server2",
 *                 Type = "SqlElasticPool",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server3",
 *                 ShardMapName = "shardMap1",
 *                 Type = "SqlShardMap",
 *             },
 *         },
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetGroupName = "targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobTargetGroup(ctx, "jobTargetGroup", &sql.JobTargetGroupArgs{
 * 			JobAgentName: pulumi.String("agent1"),
 * 			Members: []sql.JobTargetArgs{
 * 				{
 * 					DatabaseName:   pulumi.String("database1"),
 * 					MembershipType: sql.JobTargetGroupMembershipTypeExclude,
 * 					ServerName:     pulumi.String("server1"),
 * 					Type:           pulumi.String("SqlDatabase"),
 * 				},
 * 				{
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server1"),
 * 					Type:              pulumi.String("SqlServer"),
 * 				},
 * 				{
 * 					ElasticPoolName:   pulumi.String("pool1"),
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server2"),
 * 					Type:              pulumi.String("SqlElasticPool"),
 * 				},
 * 				{
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server3"),
 * 					ShardMapName:      pulumi.String("shardMap1"),
 * 					Type:              pulumi.String("SqlShardMap"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			TargetGroupName:   pulumi.String("targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobTargetGroup;
 * import com.pulumi.azurenative.sql.JobTargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobTargetGroup = new JobTargetGroup("jobTargetGroup", JobTargetGroupArgs.builder()
 *             .jobAgentName("agent1")
 *             .members(
 *                 Map.ofEntries(
 *                     Map.entry("databaseName", "database1"),
 *                     Map.entry("membershipType", "Exclude"),
 *                     Map.entry("serverName", "server1"),
 *                     Map.entry("type", "SqlDatabase")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server1"),
 *                     Map.entry("type", "SqlServer")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("elasticPoolName", "pool1"),
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server2"),
 *                     Map.entry("type", "SqlElasticPool")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server3"),
 *                     Map.entry("shardMapName", "shardMap1"),
 *                     Map.entry("type", "SqlShardMap")
 *                 ))
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetGroupName("targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a target group with minimal properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobTargetGroup = new AzureNative.Sql.JobTargetGroup("jobTargetGroup", new()
 *     {
 *         JobAgentName = "agent1",
 *         Members = new[] {},
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetGroupName = "targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobTargetGroup(ctx, "jobTargetGroup", &sql.JobTargetGroupArgs{
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Members:           sql.JobTargetArray{},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			TargetGroupName:   pulumi.String("targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobTargetGroup;
 * import com.pulumi.azurenative.sql.JobTargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobTargetGroup = new JobTargetGroup("jobTargetGroup", JobTargetGroupArgs.builder()
 *             .jobAgentName("agent1")
 *             .members()
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetGroupName("targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobTargetGroup targetGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}
 * ```
 */
public class JobTargetGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.JobTargetGroup,
) : KotlinCustomResource(javaResource, JobTargetGroupMapper) {
    /**
     * Members of the target group.
     */
    public val members: Output<List<JobTargetResponse>>
        get() = javaResource.members().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobTargetGroupMapper : ResourceMapper<JobTargetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.JobTargetGroup::class == javaResource::class

    override fun map(javaResource: Resource): JobTargetGroup = JobTargetGroup(
        javaResource as
            com.pulumi.azurenative.sql.JobTargetGroup,
    )
}

/**
 * @see [JobTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobTargetGroup].
 */
public suspend fun jobTargetGroup(
    name: String,
    block: suspend JobTargetGroupResourceBuilder.() -> Unit,
): JobTargetGroup {
    val builder = JobTargetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobTargetGroup(name: String): JobTargetGroup {
    val builder = JobTargetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
