@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse
import com.pulumi.azurenative.sql.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagedDatabaseVulnerabilityAssessment].
 */
@PulumiTagMarker
public class ManagedDatabaseVulnerabilityAssessmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedDatabaseVulnerabilityAssessmentArgs =
        ManagedDatabaseVulnerabilityAssessmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ManagedDatabaseVulnerabilityAssessmentArgsBuilder.() -> Unit) {
        val builder = ManagedDatabaseVulnerabilityAssessmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagedDatabaseVulnerabilityAssessment {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedDatabaseVulnerabilityAssessment(builtJavaResource)
    }
}

/**
 * A database vulnerability assessment.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a database's vulnerability assessment with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessment = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", new()
 *     {
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         RecurringScans = new AzureNative.Sql.Inputs.VulnerabilityAssessmentRecurringScansPropertiesArgs
 *         {
 *             EmailSubscriptionAdmins = true,
 *             Emails = new[]
 *             {
 *                 "email1@mail.com",
 *                 "email2@mail.com",
 *             },
 *             IsEnabled = true,
 *         },
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessment(ctx, "managedDatabaseVulnerabilityAssessment", &sql.ManagedDatabaseVulnerabilityAssessmentArgs{
 * 			DatabaseName:        pulumi.String("testdb"),
 * 			ManagedInstanceName: pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			RecurringScans: &sql.VulnerabilityAssessmentRecurringScansPropertiesArgs{
 * 				EmailSubscriptionAdmins: pulumi.Bool(true),
 * 				Emails: pulumi.StringArray{
 * 					pulumi.String("email1@mail.com"),
 * 					pulumi.String("email2@mail.com"),
 * 				},
 * 				IsEnabled: pulumi.Bool(true),
 * 			},
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessment = new ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", ManagedDatabaseVulnerabilityAssessmentArgs.builder()
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .recurringScans(Map.ofEntries(
 *                 Map.entry("emailSubscriptionAdmins", true),
 *                 Map.entry("emails",
 *                     "email1@mail.com",
 *                     "email2@mail.com"),
 *                 Map.entry("isEnabled", true)
 *             ))
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a database's vulnerability assessment with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedDatabaseVulnerabilityAssessment = new AzureNative.Sql.ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", new()
 *     {
 *         DatabaseName = "testdb",
 *         ManagedInstanceName = "vulnerabilityaseessmenttest-6440",
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         StorageContainerPath = "https://myStorage.blob.core.windows.net/vulnerability-assessment/",
 *         StorageContainerSasKey = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewManagedDatabaseVulnerabilityAssessment(ctx, "managedDatabaseVulnerabilityAssessment", &sql.ManagedDatabaseVulnerabilityAssessmentArgs{
 * 			DatabaseName:                pulumi.String("testdb"),
 * 			ManagedInstanceName:         pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			ResourceGroupName:           pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			StorageContainerPath:        pulumi.String("https://myStorage.blob.core.windows.net/vulnerability-assessment/"),
 * 			StorageContainerSasKey:      pulumi.String("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment;
 * import com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedDatabaseVulnerabilityAssessment = new ManagedDatabaseVulnerabilityAssessment("managedDatabaseVulnerabilityAssessment", ManagedDatabaseVulnerabilityAssessmentArgs.builder()
 *             .databaseName("testdb")
 *             .managedInstanceName("vulnerabilityaseessmenttest-6440")
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .storageContainerPath("https://myStorage.blob.core.windows.net/vulnerability-assessment/")
 *             .storageContainerSasKey("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ManagedDatabaseVulnerabilityAssessment default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}
 * ```
 */
public class ManagedDatabaseVulnerabilityAssessment internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment,
) : KotlinCustomResource(javaResource, ManagedDatabaseVulnerabilityAssessmentMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The recurring scans settings
     */
    public val recurringScans: Output<VulnerabilityAssessmentRecurringScansPropertiesResponse>?
        get() = javaResource.recurringScans().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedDatabaseVulnerabilityAssessmentMapper :
    ResourceMapper<ManagedDatabaseVulnerabilityAssessment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment::class == javaResource::class

    override fun map(javaResource: Resource): ManagedDatabaseVulnerabilityAssessment =
        ManagedDatabaseVulnerabilityAssessment(
            javaResource as
                com.pulumi.azurenative.sql.ManagedDatabaseVulnerabilityAssessment,
        )
}

/**
 * @see [ManagedDatabaseVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedDatabaseVulnerabilityAssessment].
 */
public suspend fun managedDatabaseVulnerabilityAssessment(
    name: String,
    block: suspend ManagedDatabaseVulnerabilityAssessmentResourceBuilder.() -> Unit,
):
    ManagedDatabaseVulnerabilityAssessment {
    val builder = ManagedDatabaseVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedDatabaseVulnerabilityAssessment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedDatabaseVulnerabilityAssessment(name: String):
    ManagedDatabaseVulnerabilityAssessment {
    val builder = ManagedDatabaseVulnerabilityAssessmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
