@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ReplicationLinkArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ReplicationLinkType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A replication link.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### Updates Replication Link
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var replicationLink = new AzureNative.Sql.ReplicationLink("replicationLink", new()
 *     {
 *         DatabaseName = "gamma-db",
 *         LinkId = "00000000-1111-2222-3333-666666666666",
 *         LinkType = "STANDBY",
 *         ResourceGroupName = "Default",
 *         ServerName = "sourcesvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewReplicationLink(ctx, "replicationLink", &sql.ReplicationLinkArgs{
 * 			DatabaseName:      pulumi.String("gamma-db"),
 * 			LinkId:            pulumi.String("00000000-1111-2222-3333-666666666666"),
 * 			LinkType:          pulumi.String("STANDBY"),
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("sourcesvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ReplicationLink;
 * import com.pulumi.azurenative.sql.ReplicationLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var replicationLink = new ReplicationLink("replicationLink", ReplicationLinkArgs.builder()
 *             .databaseName("gamma-db")
 *             .linkId("00000000-1111-2222-3333-666666666666")
 *             .linkType("STANDBY")
 *             .resourceGroupName("Default")
 *             .serverName("sourcesvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ReplicationLink 00000000-1111-2222-3333-666666666666 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/replicationLinks/{linkId}
 * ```
 * @property databaseName The name of the database.
 * @property linkId
 * @property linkType Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class ReplicationLinkArgs(
    public val databaseName: Output<String>? = null,
    public val linkId: Output<String>? = null,
    public val linkType: Output<Either<String, ReplicationLinkType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ReplicationLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ReplicationLinkArgs =
        com.pulumi.azurenative.sql.ReplicationLinkArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .linkId(linkId?.applyValue({ args0 -> args0 }))
            .linkType(
                linkType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReplicationLinkArgs].
 */
@PulumiTagMarker
public class ReplicationLinkArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var linkId: Output<String>? = null

    private var linkType: Output<Either<String, ReplicationLinkType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("fmtsrfyunbabentj")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value
     */
    @JvmName("hebevxroqcrumelg")
    public suspend fun linkId(`value`: Output<String>) {
        this.linkId = value
    }

    /**
     * @param value Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     */
    @JvmName("jchehdqwnvsuhlav")
    public suspend fun linkType(`value`: Output<Either<String, ReplicationLinkType>>) {
        this.linkType = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("avpowfcdpmoxibrx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("uqtbnsfaojplqrvl")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("jiftcewqpxjshqdq")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value
     */
    @JvmName("rcmvvvwccxttxcbh")
    public suspend fun linkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkId = mapped
    }

    /**
     * @param value Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     */
    @JvmName("voiexutkbnhtvaio")
    public suspend fun linkType(`value`: Either<String, ReplicationLinkType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     */
    @JvmName("utrgbrofeaywlkyg")
    public fun linkType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationLinkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     */
    @JvmName("darvkloaekricebi")
    public fun linkType(`value`: ReplicationLinkType) {
        val toBeMapped = Either.ofRight<String, ReplicationLinkType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkType = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xtqtbxyxdvjqtjpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("fxsbwuxbqblqbqlw")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): ReplicationLinkArgs = ReplicationLinkArgs(
        databaseName = databaseName,
        linkId = linkId,
        linkType = linkType,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
