@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.SqlFunctions.getBackupLongTermRetentionPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getBackupShortTermRetentionPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDataMaskingPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseAdvisorPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseBlobAuditingPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabasePlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseSecurityAlertPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseSqlVulnerabilityAssessmentRuleBaselinePlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseThreatDetectionPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseVulnerabilityAssessmentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDatabaseVulnerabilityAssessmentRuleBaselinePlain
import com.pulumi.azurenative.sql.SqlFunctions.getDisasterRecoveryConfigurationPlain
import com.pulumi.azurenative.sql.SqlFunctions.getDistributedAvailabilityGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getElasticPoolPlain
import com.pulumi.azurenative.sql.SqlFunctions.getEncryptionProtectorPlain
import com.pulumi.azurenative.sql.SqlFunctions.getExtendedDatabaseBlobAuditingPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getExtendedServerBlobAuditingPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getFailoverGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getFirewallRulePlain
import com.pulumi.azurenative.sql.SqlFunctions.getGeoBackupPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getIPv6FirewallRulePlain
import com.pulumi.azurenative.sql.SqlFunctions.getInstanceFailoverGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getInstancePoolPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobAgentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobCredentialPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobPrivateEndpointPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobStepPlain
import com.pulumi.azurenative.sql.SqlFunctions.getJobTargetGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getLongTermRetentionPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedDatabasePlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedDatabaseSensitivityLabelPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedDatabaseVulnerabilityAssessmentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedDatabaseVulnerabilityAssessmentRuleBaselinePlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstanceAdministratorPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstanceAzureADOnlyAuthenticationPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstanceKeyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstanceLongTermRetentionPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstancePlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstancePrivateEndpointConnectionPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedInstanceVulnerabilityAssessmentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getManagedServerDnsAliasPlain
import com.pulumi.azurenative.sql.SqlFunctions.getOutboundFirewallRulePlain
import com.pulumi.azurenative.sql.SqlFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.sql.SqlFunctions.getReplicationLinkPlain
import com.pulumi.azurenative.sql.SqlFunctions.getSensitivityLabelPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerAdvisorPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerAzureADAdministratorPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerAzureADOnlyAuthenticationPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerBlobAuditingPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerCommunicationLinkPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerDnsAliasPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerKeyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerSecurityAlertPolicyPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerTrustCertificatePlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerTrustGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getServerVulnerabilityAssessmentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getSqlVulnerabilityAssessmentRuleBaselinePlain
import com.pulumi.azurenative.sql.SqlFunctions.getSqlVulnerabilityAssessmentsSettingPlain
import com.pulumi.azurenative.sql.SqlFunctions.getStartStopManagedInstanceSchedulePlain
import com.pulumi.azurenative.sql.SqlFunctions.getSyncAgentPlain
import com.pulumi.azurenative.sql.SqlFunctions.getSyncGroupPlain
import com.pulumi.azurenative.sql.SqlFunctions.getSyncMemberPlain
import com.pulumi.azurenative.sql.SqlFunctions.getTransparentDataEncryptionPlain
import com.pulumi.azurenative.sql.SqlFunctions.getVirtualNetworkRulePlain
import com.pulumi.azurenative.sql.SqlFunctions.getWorkloadClassifierPlain
import com.pulumi.azurenative.sql.SqlFunctions.getWorkloadGroupPlain
import com.pulumi.azurenative.sql.kotlin.inputs.GetBackupLongTermRetentionPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetBackupLongTermRetentionPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetBackupShortTermRetentionPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetBackupShortTermRetentionPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDataMaskingPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDataMaskingPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseAdvisorPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseAdvisorPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseBlobAuditingPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseBlobAuditingPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseSecurityAlertPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseSecurityAlertPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseThreatDetectionPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseThreatDetectionPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDisasterRecoveryConfigurationPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDisasterRecoveryConfigurationPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetDistributedAvailabilityGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetDistributedAvailabilityGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetElasticPoolPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetElasticPoolPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetEncryptionProtectorPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetEncryptionProtectorPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetExtendedDatabaseBlobAuditingPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetExtendedServerBlobAuditingPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetExtendedServerBlobAuditingPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetFailoverGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetFailoverGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetGeoBackupPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetGeoBackupPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetIPv6FirewallRulePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetIPv6FirewallRulePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetInstanceFailoverGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetInstanceFailoverGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetInstancePoolPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetInstancePoolPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobAgentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobAgentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobCredentialPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobCredentialPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobPrivateEndpointPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobPrivateEndpointPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobStepPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobStepPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobTargetGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetJobTargetGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetLongTermRetentionPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetLongTermRetentionPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabasePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabasePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseSensitivityLabelPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseSensitivityLabelPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceAdministratorPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceAdministratorPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceAzureADOnlyAuthenticationPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceKeyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceKeyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceLongTermRetentionPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstancePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstancePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstancePrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedInstanceVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedServerDnsAliasPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetManagedServerDnsAliasPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetOutboundFirewallRulePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetOutboundFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetReplicationLinkPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetReplicationLinkPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSensitivityLabelPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSensitivityLabelPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAdvisorPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAdvisorPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAzureADAdministratorPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAzureADAdministratorPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAzureADOnlyAuthenticationPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerAzureADOnlyAuthenticationPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerBlobAuditingPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerBlobAuditingPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerCommunicationLinkPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerCommunicationLinkPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerDnsAliasPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerDnsAliasPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerKeyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerKeyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerSecurityAlertPolicyPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerSecurityAlertPolicyPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerTrustCertificatePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerTrustCertificatePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerTrustGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerTrustGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerVulnerabilityAssessmentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetServerVulnerabilityAssessmentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSqlVulnerabilityAssessmentRuleBaselinePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetStartStopManagedInstanceSchedulePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetStartStopManagedInstanceSchedulePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncAgentPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncAgentPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncMemberPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetSyncMemberPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetTransparentDataEncryptionPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetTransparentDataEncryptionPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetVirtualNetworkRulePlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetVirtualNetworkRulePlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetWorkloadClassifierPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetWorkloadClassifierPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.inputs.GetWorkloadGroupPlainArgs
import com.pulumi.azurenative.sql.kotlin.inputs.GetWorkloadGroupPlainArgsBuilder
import com.pulumi.azurenative.sql.kotlin.outputs.GetBackupLongTermRetentionPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetBackupShortTermRetentionPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDataMaskingPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseAdvisorResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseBlobAuditingPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseSecurityAlertPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseThreatDetectionPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseVulnerabilityAssessmentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseVulnerabilityAssessmentRuleBaselineResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDisasterRecoveryConfigurationResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetDistributedAvailabilityGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetElasticPoolResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetEncryptionProtectorResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetExtendedDatabaseBlobAuditingPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetExtendedServerBlobAuditingPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetFailoverGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetGeoBackupPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetIPv6FirewallRuleResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetInstanceFailoverGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetInstancePoolResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobAgentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobCredentialResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobPrivateEndpointResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobStepResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobTargetGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetLongTermRetentionPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseSensitivityLabelResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseVulnerabilityAssessmentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceAdministratorResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceAzureADOnlyAuthenticationResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceKeyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceLongTermRetentionPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstancePrivateEndpointConnectionResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceVulnerabilityAssessmentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedServerDnsAliasResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetOutboundFirewallRuleResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetReplicationLinkResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSensitivityLabelResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAdvisorResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAzureADAdministratorResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAzureADOnlyAuthenticationResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerBlobAuditingPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerCommunicationLinkResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerDnsAliasResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerKeyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerSecurityAlertPolicyResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerTrustCertificateResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerTrustGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerVulnerabilityAssessmentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSqlVulnerabilityAssessmentRuleBaselineResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSqlVulnerabilityAssessmentsSettingResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetStartStopManagedInstanceScheduleResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncAgentResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncGroupResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncMemberResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetTransparentDataEncryptionResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetVirtualNetworkRuleResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetWorkloadClassifierResult
import com.pulumi.azurenative.sql.kotlin.outputs.GetWorkloadGroupResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.sql.kotlin.outputs.GetBackupLongTermRetentionPolicyResult.Companion.toKotlin as getBackupLongTermRetentionPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetBackupShortTermRetentionPolicyResult.Companion.toKotlin as getBackupShortTermRetentionPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDataMaskingPolicyResult.Companion.toKotlin as getDataMaskingPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseAdvisorResult.Companion.toKotlin as getDatabaseAdvisorResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseBlobAuditingPolicyResult.Companion.toKotlin as getDatabaseBlobAuditingPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseSecurityAlertPolicyResult.Companion.toKotlin as getDatabaseSecurityAlertPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult.Companion.toKotlin as getDatabaseSqlVulnerabilityAssessmentRuleBaselineResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseThreatDetectionPolicyResult.Companion.toKotlin as getDatabaseThreatDetectionPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseVulnerabilityAssessmentResult.Companion.toKotlin as getDatabaseVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDatabaseVulnerabilityAssessmentRuleBaselineResult.Companion.toKotlin as getDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDisasterRecoveryConfigurationResult.Companion.toKotlin as getDisasterRecoveryConfigurationResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetDistributedAvailabilityGroupResult.Companion.toKotlin as getDistributedAvailabilityGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetElasticPoolResult.Companion.toKotlin as getElasticPoolResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetEncryptionProtectorResult.Companion.toKotlin as getEncryptionProtectorResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetExtendedDatabaseBlobAuditingPolicyResult.Companion.toKotlin as getExtendedDatabaseBlobAuditingPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetExtendedServerBlobAuditingPolicyResult.Companion.toKotlin as getExtendedServerBlobAuditingPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetFailoverGroupResult.Companion.toKotlin as getFailoverGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetGeoBackupPolicyResult.Companion.toKotlin as getGeoBackupPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetIPv6FirewallRuleResult.Companion.toKotlin as getIPv6FirewallRuleResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetInstanceFailoverGroupResult.Companion.toKotlin as getInstanceFailoverGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetInstancePoolResult.Companion.toKotlin as getInstancePoolResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobAgentResult.Companion.toKotlin as getJobAgentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobCredentialResult.Companion.toKotlin as getJobCredentialResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobPrivateEndpointResult.Companion.toKotlin as getJobPrivateEndpointResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobStepResult.Companion.toKotlin as getJobStepResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetJobTargetGroupResult.Companion.toKotlin as getJobTargetGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetLongTermRetentionPolicyResult.Companion.toKotlin as getLongTermRetentionPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseResult.Companion.toKotlin as getManagedDatabaseResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseSensitivityLabelResult.Companion.toKotlin as getManagedDatabaseSensitivityLabelResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseVulnerabilityAssessmentResult.Companion.toKotlin as getManagedDatabaseVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult.Companion.toKotlin as getManagedDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceAdministratorResult.Companion.toKotlin as getManagedInstanceAdministratorResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceAzureADOnlyAuthenticationResult.Companion.toKotlin as getManagedInstanceAzureADOnlyAuthenticationResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceKeyResult.Companion.toKotlin as getManagedInstanceKeyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceLongTermRetentionPolicyResult.Companion.toKotlin as getManagedInstanceLongTermRetentionPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstancePrivateEndpointConnectionResult.Companion.toKotlin as getManagedInstancePrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceResult.Companion.toKotlin as getManagedInstanceResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedInstanceVulnerabilityAssessmentResult.Companion.toKotlin as getManagedInstanceVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetManagedServerDnsAliasResult.Companion.toKotlin as getManagedServerDnsAliasResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetOutboundFirewallRuleResult.Companion.toKotlin as getOutboundFirewallRuleResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetReplicationLinkResult.Companion.toKotlin as getReplicationLinkResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSensitivityLabelResult.Companion.toKotlin as getSensitivityLabelResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAdvisorResult.Companion.toKotlin as getServerAdvisorResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAzureADAdministratorResult.Companion.toKotlin as getServerAzureADAdministratorResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerAzureADOnlyAuthenticationResult.Companion.toKotlin as getServerAzureADOnlyAuthenticationResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerBlobAuditingPolicyResult.Companion.toKotlin as getServerBlobAuditingPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerCommunicationLinkResult.Companion.toKotlin as getServerCommunicationLinkResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerDnsAliasResult.Companion.toKotlin as getServerDnsAliasResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerKeyResult.Companion.toKotlin as getServerKeyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerResult.Companion.toKotlin as getServerResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerSecurityAlertPolicyResult.Companion.toKotlin as getServerSecurityAlertPolicyResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerTrustCertificateResult.Companion.toKotlin as getServerTrustCertificateResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerTrustGroupResult.Companion.toKotlin as getServerTrustGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetServerVulnerabilityAssessmentResult.Companion.toKotlin as getServerVulnerabilityAssessmentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSqlVulnerabilityAssessmentRuleBaselineResult.Companion.toKotlin as getSqlVulnerabilityAssessmentRuleBaselineResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSqlVulnerabilityAssessmentsSettingResult.Companion.toKotlin as getSqlVulnerabilityAssessmentsSettingResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetStartStopManagedInstanceScheduleResult.Companion.toKotlin as getStartStopManagedInstanceScheduleResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncAgentResult.Companion.toKotlin as getSyncAgentResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncGroupResult.Companion.toKotlin as getSyncGroupResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetSyncMemberResult.Companion.toKotlin as getSyncMemberResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetTransparentDataEncryptionResult.Companion.toKotlin as getTransparentDataEncryptionResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetVirtualNetworkRuleResult.Companion.toKotlin as getVirtualNetworkRuleResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetWorkloadClassifierResult.Companion.toKotlin as getWorkloadClassifierResultToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.GetWorkloadGroupResult.Companion.toKotlin as getWorkloadGroupResultToKotlin

public object SqlFunctions {
    /**
     * Gets a database's long term retention policy.
     * Azure REST API version: 2017-03-01-preview.
     * @param argument null
     * @return A long term retention policy.
     */
    public suspend
    fun getBackupLongTermRetentionPolicy(argument: GetBackupLongTermRetentionPolicyPlainArgs):
        GetBackupLongTermRetentionPolicyResult =
        getBackupLongTermRetentionPolicyResultToKotlin(getBackupLongTermRetentionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBackupLongTermRetentionPolicy].
     * @param databaseName The name of the database.
     * @param policyName The policy name. Should always be Default.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A long term retention policy.
     */
    public suspend fun getBackupLongTermRetentionPolicy(
        databaseName: String,
        policyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetBackupLongTermRetentionPolicyResult {
        val argument = GetBackupLongTermRetentionPolicyPlainArgs(
            databaseName = databaseName,
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getBackupLongTermRetentionPolicyResultToKotlin(getBackupLongTermRetentionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupLongTermRetentionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetBackupLongTermRetentionPolicyPlainArgs].
     * @return A long term retention policy.
     */
    public suspend
    fun getBackupLongTermRetentionPolicy(argument: suspend GetBackupLongTermRetentionPolicyPlainArgsBuilder.() -> Unit):
        GetBackupLongTermRetentionPolicyResult {
        val builder = GetBackupLongTermRetentionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupLongTermRetentionPolicyResultToKotlin(getBackupLongTermRetentionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's short term retention policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A short term retention policy.
     */
    public suspend
    fun getBackupShortTermRetentionPolicy(argument: GetBackupShortTermRetentionPolicyPlainArgs):
        GetBackupShortTermRetentionPolicyResult =
        getBackupShortTermRetentionPolicyResultToKotlin(getBackupShortTermRetentionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getBackupShortTermRetentionPolicy].
     * @param databaseName The name of the database.
     * @param policyName The policy name. Should always be "default".
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A short term retention policy.
     */
    public suspend fun getBackupShortTermRetentionPolicy(
        databaseName: String,
        policyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetBackupShortTermRetentionPolicyResult {
        val argument = GetBackupShortTermRetentionPolicyPlainArgs(
            databaseName = databaseName,
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getBackupShortTermRetentionPolicyResultToKotlin(getBackupShortTermRetentionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getBackupShortTermRetentionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetBackupShortTermRetentionPolicyPlainArgs].
     * @return A short term retention policy.
     */
    public suspend
    fun getBackupShortTermRetentionPolicy(argument: suspend GetBackupShortTermRetentionPolicyPlainArgsBuilder.() -> Unit):
        GetBackupShortTermRetentionPolicyResult {
        val builder = GetBackupShortTermRetentionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBackupShortTermRetentionPolicyResultToKotlin(getBackupShortTermRetentionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the database data masking policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database data masking policy.
     */
    public suspend fun getDataMaskingPolicy(argument: GetDataMaskingPolicyPlainArgs):
        GetDataMaskingPolicyResult =
        getDataMaskingPolicyResultToKotlin(getDataMaskingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getDataMaskingPolicy].
     * @param dataMaskingPolicyName The name of the database for which the data masking policy applies.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A database data masking policy.
     */
    public suspend fun getDataMaskingPolicy(
        dataMaskingPolicyName: String,
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDataMaskingPolicyResult {
        val argument = GetDataMaskingPolicyPlainArgs(
            dataMaskingPolicyName = dataMaskingPolicyName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDataMaskingPolicyResultToKotlin(getDataMaskingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataMaskingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDataMaskingPolicyPlainArgs].
     * @return A database data masking policy.
     */
    public suspend
    fun getDataMaskingPolicy(argument: suspend GetDataMaskingPolicyPlainArgsBuilder.() -> Unit):
        GetDataMaskingPolicyResult {
        val builder = GetDataMaskingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataMaskingPolicyResultToKotlin(getDataMaskingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2019-06-01-preview, 2020-02-02-preview, 2020-08-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database resource.
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A database resource.
     */
    public suspend fun getDatabase(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return A database resource.
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit):
        GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database advisor.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend fun getDatabaseAdvisor(argument: GetDatabaseAdvisorPlainArgs):
        GetDatabaseAdvisorResult =
        getDatabaseAdvisorResultToKotlin(getDatabaseAdvisorPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseAdvisor].
     * @param advisorName The name of the Database Advisor.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend fun getDatabaseAdvisor(
        advisorName: String,
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseAdvisorResult {
        val argument = GetDatabaseAdvisorPlainArgs(
            advisorName = advisorName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseAdvisorResultToKotlin(getDatabaseAdvisorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseAdvisor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseAdvisorPlainArgs].
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend
    fun getDatabaseAdvisor(argument: suspend GetDatabaseAdvisorPlainArgsBuilder.() -> Unit):
        GetDatabaseAdvisorResult {
        val builder = GetDatabaseAdvisorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseAdvisorResultToKotlin(getDatabaseAdvisorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's blob auditing policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database blob auditing policy.
     */
    public suspend
    fun getDatabaseBlobAuditingPolicy(argument: GetDatabaseBlobAuditingPolicyPlainArgs):
        GetDatabaseBlobAuditingPolicyResult =
        getDatabaseBlobAuditingPolicyResultToKotlin(getDatabaseBlobAuditingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseBlobAuditingPolicy].
     * @param blobAuditingPolicyName The name of the blob auditing policy.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A database blob auditing policy.
     */
    public suspend fun getDatabaseBlobAuditingPolicy(
        blobAuditingPolicyName: String,
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseBlobAuditingPolicyResult {
        val argument = GetDatabaseBlobAuditingPolicyPlainArgs(
            blobAuditingPolicyName = blobAuditingPolicyName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseBlobAuditingPolicyResultToKotlin(getDatabaseBlobAuditingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseBlobAuditingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseBlobAuditingPolicyPlainArgs].
     * @return A database blob auditing policy.
     */
    public suspend
    fun getDatabaseBlobAuditingPolicy(argument: suspend GetDatabaseBlobAuditingPolicyPlainArgsBuilder.() -> Unit):
        GetDatabaseBlobAuditingPolicyResult {
        val builder = GetDatabaseBlobAuditingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseBlobAuditingPolicyResultToKotlin(getDatabaseBlobAuditingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's security alert policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2018-06-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database security alert policy.
     */
    public suspend
    fun getDatabaseSecurityAlertPolicy(argument: GetDatabaseSecurityAlertPolicyPlainArgs):
        GetDatabaseSecurityAlertPolicyResult =
        getDatabaseSecurityAlertPolicyResultToKotlin(getDatabaseSecurityAlertPolicyPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseSecurityAlertPolicy].
     * @param databaseName The name of the  database for which the security alert policy is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param securityAlertPolicyName The name of the security alert policy.
     * @param serverName The name of the  server.
     * @return A database security alert policy.
     */
    public suspend fun getDatabaseSecurityAlertPolicy(
        databaseName: String,
        resourceGroupName: String,
        securityAlertPolicyName: String,
        serverName: String,
    ): GetDatabaseSecurityAlertPolicyResult {
        val argument = GetDatabaseSecurityAlertPolicyPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            securityAlertPolicyName = securityAlertPolicyName,
            serverName = serverName,
        )
        return getDatabaseSecurityAlertPolicyResultToKotlin(getDatabaseSecurityAlertPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseSecurityAlertPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseSecurityAlertPolicyPlainArgs].
     * @return A database security alert policy.
     */
    public suspend
    fun getDatabaseSecurityAlertPolicy(argument: suspend GetDatabaseSecurityAlertPolicyPlainArgsBuilder.() -> Unit):
        GetDatabaseSecurityAlertPolicyResult {
        val builder = GetDatabaseSecurityAlertPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseSecurityAlertPolicyResultToKotlin(getDatabaseSecurityAlertPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's sql vulnerability assessment rule baseline.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend
    fun getDatabaseSqlVulnerabilityAssessmentRuleBaseline(argument: GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgs):
        GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult =
        getDatabaseSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseSqlVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())

    /**
     * @see [getDatabaseSqlVulnerabilityAssessmentRuleBaseline].
     * @param baselineName
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param ruleId The vulnerability assessment rule ID.
     * @param serverName The name of the server.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend fun getDatabaseSqlVulnerabilityAssessmentRuleBaseline(
        baselineName: String,
        databaseName: String,
        resourceGroupName: String,
        ruleId: String,
        serverName: String,
        vulnerabilityAssessmentName: String,
    ): GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult {
        val argument = GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getDatabaseSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseSqlVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseSqlVulnerabilityAssessmentRuleBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgs].
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend
    fun getDatabaseSqlVulnerabilityAssessmentRuleBaseline(argument: suspend GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder.() -> Unit):
        GetDatabaseSqlVulnerabilityAssessmentRuleBaselineResult {
        val builder = GetDatabaseSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseSqlVulnerabilityAssessmentRuleBaselinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's threat detection policy.
     * Azure REST API version: 2014-04-01.
     * @param argument null
     * @return Contains information about a database Threat Detection policy.
     */
    public suspend
    fun getDatabaseThreatDetectionPolicy(argument: GetDatabaseThreatDetectionPolicyPlainArgs):
        GetDatabaseThreatDetectionPolicyResult =
        getDatabaseThreatDetectionPolicyResultToKotlin(getDatabaseThreatDetectionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseThreatDetectionPolicy].
     * @param databaseName The name of the database for which database Threat Detection policy is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param securityAlertPolicyName The name of the security alert policy.
     * @param serverName The name of the server.
     * @return Contains information about a database Threat Detection policy.
     */
    public suspend fun getDatabaseThreatDetectionPolicy(
        databaseName: String,
        resourceGroupName: String,
        securityAlertPolicyName: String,
        serverName: String,
    ): GetDatabaseThreatDetectionPolicyResult {
        val argument = GetDatabaseThreatDetectionPolicyPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            securityAlertPolicyName = securityAlertPolicyName,
            serverName = serverName,
        )
        return getDatabaseThreatDetectionPolicyResultToKotlin(getDatabaseThreatDetectionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseThreatDetectionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseThreatDetectionPolicyPlainArgs].
     * @return Contains information about a database Threat Detection policy.
     */
    public suspend
    fun getDatabaseThreatDetectionPolicy(argument: suspend GetDatabaseThreatDetectionPolicyPlainArgsBuilder.() -> Unit):
        GetDatabaseThreatDetectionPolicyResult {
        val builder = GetDatabaseThreatDetectionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseThreatDetectionPolicyResultToKotlin(getDatabaseThreatDetectionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the database's vulnerability assessment.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database vulnerability assessment.
     */
    public suspend
    fun getDatabaseVulnerabilityAssessment(argument: GetDatabaseVulnerabilityAssessmentPlainArgs):
        GetDatabaseVulnerabilityAssessmentResult =
        getDatabaseVulnerabilityAssessmentResultToKotlin(getDatabaseVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getDatabaseVulnerabilityAssessment].
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database vulnerability assessment.
     */
    public suspend fun getDatabaseVulnerabilityAssessment(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        vulnerabilityAssessmentName: String,
    ): GetDatabaseVulnerabilityAssessmentResult {
        val argument = GetDatabaseVulnerabilityAssessmentPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getDatabaseVulnerabilityAssessmentResultToKotlin(getDatabaseVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseVulnerabilityAssessmentPlainArgs].
     * @return A database vulnerability assessment.
     */
    public suspend
    fun getDatabaseVulnerabilityAssessment(argument: suspend GetDatabaseVulnerabilityAssessmentPlainArgsBuilder.() -> Unit):
        GetDatabaseVulnerabilityAssessmentResult {
        val builder = GetDatabaseVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseVulnerabilityAssessmentResultToKotlin(getDatabaseVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend
    fun getDatabaseVulnerabilityAssessmentRuleBaseline(argument: GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs):
        GetDatabaseVulnerabilityAssessmentRuleBaselineResult =
        getDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())

    /**
     * @see [getDatabaseVulnerabilityAssessmentRuleBaseline].
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param ruleId The vulnerability assessment rule ID.
     * @param serverName The name of the server.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend fun getDatabaseVulnerabilityAssessmentRuleBaseline(
        baselineName: String,
        databaseName: String,
        resourceGroupName: String,
        ruleId: String,
        serverName: String,
        vulnerabilityAssessmentName: String,
    ): GetDatabaseVulnerabilityAssessmentRuleBaselineResult {
        val argument = GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabaseVulnerabilityAssessmentRuleBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs].
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend
    fun getDatabaseVulnerabilityAssessmentRuleBaseline(argument: suspend GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder.() -> Unit):
        GetDatabaseVulnerabilityAssessmentRuleBaselineResult {
        val builder = GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getDatabaseVulnerabilityAssessmentRuleBaselinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a disaster recovery configuration.
     * Azure REST API version: 2014-04-01.
     * @param argument null
     * @return Represents a disaster recovery configuration.
     */
    public suspend
    fun getDisasterRecoveryConfiguration(argument: GetDisasterRecoveryConfigurationPlainArgs):
        GetDisasterRecoveryConfigurationResult =
        getDisasterRecoveryConfigurationResultToKotlin(getDisasterRecoveryConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getDisasterRecoveryConfiguration].
     * @param disasterRecoveryConfigurationName The name of the disaster recovery configuration.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Represents a disaster recovery configuration.
     */
    public suspend fun getDisasterRecoveryConfiguration(
        disasterRecoveryConfigurationName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDisasterRecoveryConfigurationResult {
        val argument = GetDisasterRecoveryConfigurationPlainArgs(
            disasterRecoveryConfigurationName = disasterRecoveryConfigurationName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDisasterRecoveryConfigurationResultToKotlin(getDisasterRecoveryConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getDisasterRecoveryConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDisasterRecoveryConfigurationPlainArgs].
     * @return Represents a disaster recovery configuration.
     */
    public suspend
    fun getDisasterRecoveryConfiguration(argument: suspend GetDisasterRecoveryConfigurationPlainArgsBuilder.() -> Unit):
        GetDisasterRecoveryConfigurationResult {
        val builder = GetDisasterRecoveryConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDisasterRecoveryConfigurationResultToKotlin(getDisasterRecoveryConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a distributed availability group info.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Distributed availability group between box and Sql Managed Instance.
     */
    public suspend
    fun getDistributedAvailabilityGroup(argument: GetDistributedAvailabilityGroupPlainArgs):
        GetDistributedAvailabilityGroupResult =
        getDistributedAvailabilityGroupResultToKotlin(getDistributedAvailabilityGroupPlain(argument.toJava()).await())

    /**
     * @see [getDistributedAvailabilityGroup].
     * @param distributedAvailabilityGroupName The distributed availability group name.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return Distributed availability group between box and Sql Managed Instance.
     */
    public suspend fun getDistributedAvailabilityGroup(
        distributedAvailabilityGroupName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetDistributedAvailabilityGroupResult {
        val argument = GetDistributedAvailabilityGroupPlainArgs(
            distributedAvailabilityGroupName = distributedAvailabilityGroupName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getDistributedAvailabilityGroupResultToKotlin(getDistributedAvailabilityGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getDistributedAvailabilityGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetDistributedAvailabilityGroupPlainArgs].
     * @return Distributed availability group between box and Sql Managed Instance.
     */
    public suspend
    fun getDistributedAvailabilityGroup(argument: suspend GetDistributedAvailabilityGroupPlainArgsBuilder.() -> Unit):
        GetDistributedAvailabilityGroupResult {
        val builder = GetDistributedAvailabilityGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDistributedAvailabilityGroupResultToKotlin(getDistributedAvailabilityGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an elastic pool.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An elastic pool.
     */
    public suspend fun getElasticPool(argument: GetElasticPoolPlainArgs): GetElasticPoolResult =
        getElasticPoolResultToKotlin(getElasticPoolPlain(argument.toJava()).await())

    /**
     * @see [getElasticPool].
     * @param elasticPoolName The name of the elastic pool.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An elastic pool.
     */
    public suspend fun getElasticPool(
        elasticPoolName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetElasticPoolResult {
        val argument = GetElasticPoolPlainArgs(
            elasticPoolName = elasticPoolName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getElasticPoolResultToKotlin(getElasticPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getElasticPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetElasticPoolPlainArgs].
     * @return An elastic pool.
     */
    public suspend fun getElasticPool(argument: suspend GetElasticPoolPlainArgsBuilder.() -> Unit):
        GetElasticPoolResult {
        val builder = GetElasticPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getElasticPoolResultToKotlin(getElasticPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server encryption protector.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return The server encryption protector.
     */
    public suspend fun getEncryptionProtector(argument: GetEncryptionProtectorPlainArgs):
        GetEncryptionProtectorResult =
        getEncryptionProtectorResultToKotlin(getEncryptionProtectorPlain(argument.toJava()).await())

    /**
     * @see [getEncryptionProtector].
     * @param encryptionProtectorName The name of the encryption protector to be retrieved.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return The server encryption protector.
     */
    public suspend fun getEncryptionProtector(
        encryptionProtectorName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetEncryptionProtectorResult {
        val argument = GetEncryptionProtectorPlainArgs(
            encryptionProtectorName = encryptionProtectorName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getEncryptionProtectorResultToKotlin(getEncryptionProtectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getEncryptionProtector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetEncryptionProtectorPlainArgs].
     * @return The server encryption protector.
     */
    public suspend
    fun getEncryptionProtector(argument: suspend GetEncryptionProtectorPlainArgsBuilder.() -> Unit):
        GetEncryptionProtectorResult {
        val builder = GetEncryptionProtectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEncryptionProtectorResultToKotlin(getEncryptionProtectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an extended database's blob auditing policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An extended database blob auditing policy.
     */
    public suspend
    fun getExtendedDatabaseBlobAuditingPolicy(argument: GetExtendedDatabaseBlobAuditingPolicyPlainArgs):
        GetExtendedDatabaseBlobAuditingPolicyResult =
        getExtendedDatabaseBlobAuditingPolicyResultToKotlin(getExtendedDatabaseBlobAuditingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getExtendedDatabaseBlobAuditingPolicy].
     * @param blobAuditingPolicyName The name of the blob auditing policy.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An extended database blob auditing policy.
     */
    public suspend fun getExtendedDatabaseBlobAuditingPolicy(
        blobAuditingPolicyName: String,
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetExtendedDatabaseBlobAuditingPolicyResult {
        val argument = GetExtendedDatabaseBlobAuditingPolicyPlainArgs(
            blobAuditingPolicyName = blobAuditingPolicyName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getExtendedDatabaseBlobAuditingPolicyResultToKotlin(getExtendedDatabaseBlobAuditingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtendedDatabaseBlobAuditingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetExtendedDatabaseBlobAuditingPolicyPlainArgs].
     * @return An extended database blob auditing policy.
     */
    public suspend
    fun getExtendedDatabaseBlobAuditingPolicy(argument: suspend GetExtendedDatabaseBlobAuditingPolicyPlainArgsBuilder.() -> Unit):
        GetExtendedDatabaseBlobAuditingPolicyResult {
        val builder = GetExtendedDatabaseBlobAuditingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtendedDatabaseBlobAuditingPolicyResultToKotlin(getExtendedDatabaseBlobAuditingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an extended server's blob auditing policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An extended server blob auditing policy.
     */
    public suspend
    fun getExtendedServerBlobAuditingPolicy(argument: GetExtendedServerBlobAuditingPolicyPlainArgs):
        GetExtendedServerBlobAuditingPolicyResult =
        getExtendedServerBlobAuditingPolicyResultToKotlin(getExtendedServerBlobAuditingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getExtendedServerBlobAuditingPolicy].
     * @param blobAuditingPolicyName The name of the blob auditing policy.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An extended server blob auditing policy.
     */
    public suspend fun getExtendedServerBlobAuditingPolicy(
        blobAuditingPolicyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetExtendedServerBlobAuditingPolicyResult {
        val argument = GetExtendedServerBlobAuditingPolicyPlainArgs(
            blobAuditingPolicyName = blobAuditingPolicyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getExtendedServerBlobAuditingPolicyResultToKotlin(getExtendedServerBlobAuditingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtendedServerBlobAuditingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetExtendedServerBlobAuditingPolicyPlainArgs].
     * @return An extended server blob auditing policy.
     */
    public suspend
    fun getExtendedServerBlobAuditingPolicy(argument: suspend GetExtendedServerBlobAuditingPolicyPlainArgsBuilder.() -> Unit):
        GetExtendedServerBlobAuditingPolicyResult {
        val builder = GetExtendedServerBlobAuditingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtendedServerBlobAuditingPolicyResultToKotlin(getExtendedServerBlobAuditingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a failover group.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A failover group.
     */
    public suspend fun getFailoverGroup(argument: GetFailoverGroupPlainArgs): GetFailoverGroupResult =
        getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())

    /**
     * @see [getFailoverGroup].
     * @param failoverGroupName The name of the failover group.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server containing the failover group.
     * @return A failover group.
     */
    public suspend fun getFailoverGroup(
        failoverGroupName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetFailoverGroupResult {
        val argument = GetFailoverGroupPlainArgs(
            failoverGroupName = failoverGroupName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getFailoverGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetFailoverGroupPlainArgs].
     * @return A failover group.
     */
    public suspend
    fun getFailoverGroup(argument: suspend GetFailoverGroupPlainArgsBuilder.() -> Unit):
        GetFailoverGroupResult {
        val builder = GetFailoverGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFailoverGroupResultToKotlin(getFailoverGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a firewall rule.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server firewall rule.
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param firewallRuleName The name of the firewall rule.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A server firewall rule.
     */
    public suspend fun getFirewallRule(
        firewallRuleName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return A server firewall rule.
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit):
        GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Geo backup policy for the given database resource.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A Geo backup policy.
     */
    public suspend fun getGeoBackupPolicy(argument: GetGeoBackupPolicyPlainArgs):
        GetGeoBackupPolicyResult =
        getGeoBackupPolicyResultToKotlin(getGeoBackupPolicyPlain(argument.toJava()).await())

    /**
     * @see [getGeoBackupPolicy].
     * @param databaseName The name of the database.
     * @param geoBackupPolicyName The name of the Geo backup policy. This should always be 'Default'.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A Geo backup policy.
     */
    public suspend fun getGeoBackupPolicy(
        databaseName: String,
        geoBackupPolicyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetGeoBackupPolicyResult {
        val argument = GetGeoBackupPolicyPlainArgs(
            databaseName = databaseName,
            geoBackupPolicyName = geoBackupPolicyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getGeoBackupPolicyResultToKotlin(getGeoBackupPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getGeoBackupPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetGeoBackupPolicyPlainArgs].
     * @return A Geo backup policy.
     */
    public suspend
    fun getGeoBackupPolicy(argument: suspend GetGeoBackupPolicyPlainArgsBuilder.() -> Unit):
        GetGeoBackupPolicyResult {
        val builder = GetGeoBackupPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGeoBackupPolicyResultToKotlin(getGeoBackupPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an IPv6 firewall rule.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An IPv6 server firewall rule.
     */
    public suspend fun getIPv6FirewallRule(argument: GetIPv6FirewallRulePlainArgs):
        GetIPv6FirewallRuleResult =
        getIPv6FirewallRuleResultToKotlin(getIPv6FirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getIPv6FirewallRule].
     * @param firewallRuleName The name of the firewall rule.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An IPv6 server firewall rule.
     */
    public suspend fun getIPv6FirewallRule(
        firewallRuleName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetIPv6FirewallRuleResult {
        val argument = GetIPv6FirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getIPv6FirewallRuleResultToKotlin(getIPv6FirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getIPv6FirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetIPv6FirewallRulePlainArgs].
     * @return An IPv6 server firewall rule.
     */
    public suspend
    fun getIPv6FirewallRule(argument: suspend GetIPv6FirewallRulePlainArgsBuilder.() -> Unit):
        GetIPv6FirewallRuleResult {
        val builder = GetIPv6FirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIPv6FirewallRuleResultToKotlin(getIPv6FirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a failover group.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An instance failover group.
     */
    public suspend fun getInstanceFailoverGroup(argument: GetInstanceFailoverGroupPlainArgs):
        GetInstanceFailoverGroupResult =
        getInstanceFailoverGroupResultToKotlin(getInstanceFailoverGroupPlain(argument.toJava()).await())

    /**
     * @see [getInstanceFailoverGroup].
     * @param failoverGroupName The name of the failover group.
     * @param locationName The name of the region where the resource is located.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return An instance failover group.
     */
    public suspend fun getInstanceFailoverGroup(
        failoverGroupName: String,
        locationName: String,
        resourceGroupName: String,
    ): GetInstanceFailoverGroupResult {
        val argument = GetInstanceFailoverGroupPlainArgs(
            failoverGroupName = failoverGroupName,
            locationName = locationName,
            resourceGroupName = resourceGroupName,
        )
        return getInstanceFailoverGroupResultToKotlin(getInstanceFailoverGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceFailoverGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetInstanceFailoverGroupPlainArgs].
     * @return An instance failover group.
     */
    public suspend
    fun getInstanceFailoverGroup(argument: suspend GetInstanceFailoverGroupPlainArgsBuilder.() -> Unit):
        GetInstanceFailoverGroupResult {
        val builder = GetInstanceFailoverGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceFailoverGroupResultToKotlin(getInstanceFailoverGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an instance pool.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL instance pool.
     */
    public suspend fun getInstancePool(argument: GetInstancePoolPlainArgs): GetInstancePoolResult =
        getInstancePoolResultToKotlin(getInstancePoolPlain(argument.toJava()).await())

    /**
     * @see [getInstancePool].
     * @param instancePoolName The name of the instance pool to be retrieved.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return An Azure SQL instance pool.
     */
    public suspend fun getInstancePool(instancePoolName: String, resourceGroupName: String):
        GetInstancePoolResult {
        val argument = GetInstancePoolPlainArgs(
            instancePoolName = instancePoolName,
            resourceGroupName = resourceGroupName,
        )
        return getInstancePoolResultToKotlin(getInstancePoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstancePool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetInstancePoolPlainArgs].
     * @return An Azure SQL instance pool.
     */
    public suspend fun getInstancePool(argument: suspend GetInstancePoolPlainArgsBuilder.() -> Unit):
        GetInstancePoolResult {
        val builder = GetInstancePoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancePoolResultToKotlin(getInstancePoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a job.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A job.
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job to get.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A job.
     */
    public suspend fun getJob(
        jobAgentName: String,
        jobName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetJobResult {
        val argument = GetJobPlainArgs(
            jobAgentName = jobAgentName,
            jobName = jobName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return A job.
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a job agent.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL job agent.
     */
    public suspend fun getJobAgent(argument: GetJobAgentPlainArgs): GetJobAgentResult =
        getJobAgentResultToKotlin(getJobAgentPlain(argument.toJava()).await())

    /**
     * @see [getJobAgent].
     * @param jobAgentName The name of the job agent to be retrieved.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An Azure SQL job agent.
     */
    public suspend fun getJobAgent(
        jobAgentName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetJobAgentResult {
        val argument = GetJobAgentPlainArgs(
            jobAgentName = jobAgentName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getJobAgentResultToKotlin(getJobAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobAgentPlainArgs].
     * @return An Azure SQL job agent.
     */
    public suspend fun getJobAgent(argument: suspend GetJobAgentPlainArgsBuilder.() -> Unit):
        GetJobAgentResult {
        val builder = GetJobAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobAgentResultToKotlin(getJobAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a jobs credential.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A stored credential that can be used by a job to connect to target databases.
     */
    public suspend fun getJobCredential(argument: GetJobCredentialPlainArgs): GetJobCredentialResult =
        getJobCredentialResultToKotlin(getJobCredentialPlain(argument.toJava()).await())

    /**
     * @see [getJobCredential].
     * @param credentialName The name of the credential.
     * @param jobAgentName The name of the job agent.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A stored credential that can be used by a job to connect to target databases.
     */
    public suspend fun getJobCredential(
        credentialName: String,
        jobAgentName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetJobCredentialResult {
        val argument = GetJobCredentialPlainArgs(
            credentialName = credentialName,
            jobAgentName = jobAgentName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getJobCredentialResultToKotlin(getJobCredentialPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobCredential].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobCredentialPlainArgs].
     * @return A stored credential that can be used by a job to connect to target databases.
     */
    public suspend
    fun getJobCredential(argument: suspend GetJobCredentialPlainArgsBuilder.() -> Unit):
        GetJobCredentialResult {
        val builder = GetJobCredentialPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobCredentialResultToKotlin(getJobCredentialPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint.
     * Azure REST API version: 2023-05-01-preview.
     * @param argument null
     * @return A job agent private endpoint.
     */
    public suspend fun getJobPrivateEndpoint(argument: GetJobPrivateEndpointPlainArgs):
        GetJobPrivateEndpointResult =
        getJobPrivateEndpointResultToKotlin(getJobPrivateEndpointPlain(argument.toJava()).await())

    /**
     * @see [getJobPrivateEndpoint].
     * @param jobAgentName The name of the job agent.
     * @param privateEndpointName The name of the private endpoint to get.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A job agent private endpoint.
     */
    public suspend fun getJobPrivateEndpoint(
        jobAgentName: String,
        privateEndpointName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetJobPrivateEndpointResult {
        val argument = GetJobPrivateEndpointPlainArgs(
            jobAgentName = jobAgentName,
            privateEndpointName = privateEndpointName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getJobPrivateEndpointResultToKotlin(getJobPrivateEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobPrivateEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobPrivateEndpointPlainArgs].
     * @return A job agent private endpoint.
     */
    public suspend
    fun getJobPrivateEndpoint(argument: suspend GetJobPrivateEndpointPlainArgsBuilder.() -> Unit):
        GetJobPrivateEndpointResult {
        val builder = GetJobPrivateEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobPrivateEndpointResultToKotlin(getJobPrivateEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a job step in a job's current version.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A job step.
     */
    public suspend fun getJobStep(argument: GetJobStepPlainArgs): GetJobStepResult =
        getJobStepResultToKotlin(getJobStepPlain(argument.toJava()).await())

    /**
     * @see [getJobStep].
     * @param jobAgentName The name of the job agent.
     * @param jobName The name of the job.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param stepName The name of the job step.
     * @return A job step.
     */
    public suspend fun getJobStep(
        jobAgentName: String,
        jobName: String,
        resourceGroupName: String,
        serverName: String,
        stepName: String,
    ): GetJobStepResult {
        val argument = GetJobStepPlainArgs(
            jobAgentName = jobAgentName,
            jobName = jobName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            stepName = stepName,
        )
        return getJobStepResultToKotlin(getJobStepPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobStep].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobStepPlainArgs].
     * @return A job step.
     */
    public suspend fun getJobStep(argument: suspend GetJobStepPlainArgsBuilder.() -> Unit):
        GetJobStepResult {
        val builder = GetJobStepPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobStepResultToKotlin(getJobStepPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a target group.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A group of job targets.
     */
    public suspend fun getJobTargetGroup(argument: GetJobTargetGroupPlainArgs):
        GetJobTargetGroupResult =
        getJobTargetGroupResultToKotlin(getJobTargetGroupPlain(argument.toJava()).await())

    /**
     * @see [getJobTargetGroup].
     * @param jobAgentName The name of the job agent.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param targetGroupName The name of the target group.
     * @return A group of job targets.
     */
    public suspend fun getJobTargetGroup(
        jobAgentName: String,
        resourceGroupName: String,
        serverName: String,
        targetGroupName: String,
    ): GetJobTargetGroupResult {
        val argument = GetJobTargetGroupPlainArgs(
            jobAgentName = jobAgentName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            targetGroupName = targetGroupName,
        )
        return getJobTargetGroupResultToKotlin(getJobTargetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobTargetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetJobTargetGroupPlainArgs].
     * @return A group of job targets.
     */
    public suspend
    fun getJobTargetGroup(argument: suspend GetJobTargetGroupPlainArgsBuilder.() -> Unit):
        GetJobTargetGroupResult {
        val builder = GetJobTargetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobTargetGroupResultToKotlin(getJobTargetGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's long term retention policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A long term retention policy.
     */
    public suspend fun getLongTermRetentionPolicy(argument: GetLongTermRetentionPolicyPlainArgs):
        GetLongTermRetentionPolicyResult =
        getLongTermRetentionPolicyResultToKotlin(getLongTermRetentionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getLongTermRetentionPolicy].
     * @param databaseName The name of the database.
     * @param policyName The policy name. Should always be Default.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A long term retention policy.
     */
    public suspend fun getLongTermRetentionPolicy(
        databaseName: String,
        policyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetLongTermRetentionPolicyResult {
        val argument = GetLongTermRetentionPolicyPlainArgs(
            databaseName = databaseName,
            policyName = policyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getLongTermRetentionPolicyResultToKotlin(getLongTermRetentionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getLongTermRetentionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetLongTermRetentionPolicyPlainArgs].
     * @return A long term retention policy.
     */
    public suspend
    fun getLongTermRetentionPolicy(argument: suspend GetLongTermRetentionPolicyPlainArgsBuilder.() -> Unit):
        GetLongTermRetentionPolicyResult {
        val builder = GetLongTermRetentionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLongTermRetentionPolicyResultToKotlin(getLongTermRetentionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed database.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A managed database resource.
     */
    public suspend fun getManagedDatabase(argument: GetManagedDatabasePlainArgs):
        GetManagedDatabaseResult =
        getManagedDatabaseResultToKotlin(getManagedDatabasePlain(argument.toJava()).await())

    /**
     * @see [getManagedDatabase].
     * @param databaseName The name of the database.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A managed database resource.
     */
    public suspend fun getManagedDatabase(
        databaseName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedDatabaseResult {
        val argument = GetManagedDatabasePlainArgs(
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedDatabaseResultToKotlin(getManagedDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedDatabasePlainArgs].
     * @return A managed database resource.
     */
    public suspend
    fun getManagedDatabase(argument: suspend GetManagedDatabasePlainArgsBuilder.() -> Unit):
        GetManagedDatabaseResult {
        val builder = GetManagedDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedDatabaseResultToKotlin(getManagedDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sensitivity label of a given column
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A sensitivity label.
     */
    public suspend
    fun getManagedDatabaseSensitivityLabel(argument: GetManagedDatabaseSensitivityLabelPlainArgs):
        GetManagedDatabaseSensitivityLabelResult =
        getManagedDatabaseSensitivityLabelResultToKotlin(getManagedDatabaseSensitivityLabelPlain(argument.toJava()).await())

    /**
     * @see [getManagedDatabaseSensitivityLabel].
     * @param columnName The name of the column.
     * @param databaseName The name of the database.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param schemaName The name of the schema.
     * @param sensitivityLabelSource The source of the sensitivity label.
     * @param tableName The name of the table.
     * @return A sensitivity label.
     */
    public suspend fun getManagedDatabaseSensitivityLabel(
        columnName: String,
        databaseName: String,
        managedInstanceName: String,
        resourceGroupName: String,
        schemaName: String,
        sensitivityLabelSource: String,
        tableName: String,
    ): GetManagedDatabaseSensitivityLabelResult {
        val argument = GetManagedDatabaseSensitivityLabelPlainArgs(
            columnName = columnName,
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            schemaName = schemaName,
            sensitivityLabelSource = sensitivityLabelSource,
            tableName = tableName,
        )
        return getManagedDatabaseSensitivityLabelResultToKotlin(getManagedDatabaseSensitivityLabelPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedDatabaseSensitivityLabel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedDatabaseSensitivityLabelPlainArgs].
     * @return A sensitivity label.
     */
    public suspend
    fun getManagedDatabaseSensitivityLabel(argument: suspend GetManagedDatabaseSensitivityLabelPlainArgsBuilder.() -> Unit):
        GetManagedDatabaseSensitivityLabelResult {
        val builder = GetManagedDatabaseSensitivityLabelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedDatabaseSensitivityLabelResultToKotlin(getManagedDatabaseSensitivityLabelPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the database's vulnerability assessment.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database vulnerability assessment.
     */
    public suspend
    fun getManagedDatabaseVulnerabilityAssessment(argument: GetManagedDatabaseVulnerabilityAssessmentPlainArgs):
        GetManagedDatabaseVulnerabilityAssessmentResult =
        getManagedDatabaseVulnerabilityAssessmentResultToKotlin(getManagedDatabaseVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getManagedDatabaseVulnerabilityAssessment].
     * @param databaseName The name of the database for which the vulnerability assessment is defined.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database vulnerability assessment.
     */
    public suspend fun getManagedDatabaseVulnerabilityAssessment(
        databaseName: String,
        managedInstanceName: String,
        resourceGroupName: String,
        vulnerabilityAssessmentName: String,
    ): GetManagedDatabaseVulnerabilityAssessmentResult {
        val argument = GetManagedDatabaseVulnerabilityAssessmentPlainArgs(
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getManagedDatabaseVulnerabilityAssessmentResultToKotlin(getManagedDatabaseVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedDatabaseVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedDatabaseVulnerabilityAssessmentPlainArgs].
     * @return A database vulnerability assessment.
     */
    public suspend
    fun getManagedDatabaseVulnerabilityAssessment(argument: suspend GetManagedDatabaseVulnerabilityAssessmentPlainArgsBuilder.() -> Unit):
        GetManagedDatabaseVulnerabilityAssessmentResult {
        val builder = GetManagedDatabaseVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedDatabaseVulnerabilityAssessmentResultToKotlin(getManagedDatabaseVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a database's vulnerability assessment rule baseline.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend
    fun getManagedDatabaseVulnerabilityAssessmentRuleBaseline(argument: GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs):
        GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult =
        getManagedDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getManagedDatabaseVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())

    /**
     * @see [getManagedDatabaseVulnerabilityAssessmentRuleBaseline].
     * @param baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
     * @param databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param ruleId The vulnerability assessment rule ID.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend fun getManagedDatabaseVulnerabilityAssessmentRuleBaseline(
        baselineName: String,
        databaseName: String,
        managedInstanceName: String,
        resourceGroupName: String,
        ruleId: String,
        vulnerabilityAssessmentName: String,
    ): GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult {
        val argument = GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName,
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getManagedDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getManagedDatabaseVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedDatabaseVulnerabilityAssessmentRuleBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs].
     * @return A database vulnerability assessment rule baseline.
     */
    public suspend
    fun getManagedDatabaseVulnerabilityAssessmentRuleBaseline(argument: suspend GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder.() -> Unit):
        GetManagedDatabaseVulnerabilityAssessmentRuleBaselineResult {
        val builder = GetManagedDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedDatabaseVulnerabilityAssessmentRuleBaselineResultToKotlin(getManagedDatabaseVulnerabilityAssessmentRuleBaselinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed instance.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2021-02-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL managed instance.
     */
    public suspend fun getManagedInstance(argument: GetManagedInstancePlainArgs):
        GetManagedInstanceResult =
        getManagedInstanceResultToKotlin(getManagedInstancePlain(argument.toJava()).await())

    /**
     * @see [getManagedInstance].
     * @param expand The child resources to include in the response.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return An Azure SQL managed instance.
     */
    public suspend fun getManagedInstance(
        expand: String? = null,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedInstanceResult {
        val argument = GetManagedInstancePlainArgs(
            expand = expand,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstanceResultToKotlin(getManagedInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstancePlainArgs].
     * @return An Azure SQL managed instance.
     */
    public suspend
    fun getManagedInstance(argument: suspend GetManagedInstancePlainArgsBuilder.() -> Unit):
        GetManagedInstanceResult {
        val builder = GetManagedInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceResultToKotlin(getManagedInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed instance administrator.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL managed instance administrator.
     */
    public suspend
    fun getManagedInstanceAdministrator(argument: GetManagedInstanceAdministratorPlainArgs):
        GetManagedInstanceAdministratorResult =
        getManagedInstanceAdministratorResultToKotlin(getManagedInstanceAdministratorPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstanceAdministrator].
     * @param administratorName
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return An Azure SQL managed instance administrator.
     */
    public suspend fun getManagedInstanceAdministrator(
        administratorName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedInstanceAdministratorResult {
        val argument = GetManagedInstanceAdministratorPlainArgs(
            administratorName = administratorName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstanceAdministratorResultToKotlin(getManagedInstanceAdministratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstanceAdministrator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstanceAdministratorPlainArgs].
     * @return An Azure SQL managed instance administrator.
     */
    public suspend
    fun getManagedInstanceAdministrator(argument: suspend GetManagedInstanceAdministratorPlainArgsBuilder.() -> Unit):
        GetManagedInstanceAdministratorResult {
        val builder = GetManagedInstanceAdministratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceAdministratorResultToKotlin(getManagedInstanceAdministratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific Azure Active Directory only authentication property.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Azure Active Directory only authentication.
     */
    public suspend
    fun getManagedInstanceAzureADOnlyAuthentication(argument: GetManagedInstanceAzureADOnlyAuthenticationPlainArgs):
        GetManagedInstanceAzureADOnlyAuthenticationResult =
        getManagedInstanceAzureADOnlyAuthenticationResultToKotlin(getManagedInstanceAzureADOnlyAuthenticationPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstanceAzureADOnlyAuthentication].
     * @param authenticationName The name of server azure active directory only authentication.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return Azure Active Directory only authentication.
     */
    public suspend fun getManagedInstanceAzureADOnlyAuthentication(
        authenticationName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedInstanceAzureADOnlyAuthenticationResult {
        val argument = GetManagedInstanceAzureADOnlyAuthenticationPlainArgs(
            authenticationName = authenticationName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstanceAzureADOnlyAuthenticationResultToKotlin(getManagedInstanceAzureADOnlyAuthenticationPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstanceAzureADOnlyAuthentication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstanceAzureADOnlyAuthenticationPlainArgs].
     * @return Azure Active Directory only authentication.
     */
    public suspend
    fun getManagedInstanceAzureADOnlyAuthentication(argument: suspend GetManagedInstanceAzureADOnlyAuthenticationPlainArgsBuilder.() -> Unit):
        GetManagedInstanceAzureADOnlyAuthenticationResult {
        val builder = GetManagedInstanceAzureADOnlyAuthenticationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceAzureADOnlyAuthenticationResultToKotlin(getManagedInstanceAzureADOnlyAuthenticationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed instance key.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A managed instance key.
     */
    public suspend fun getManagedInstanceKey(argument: GetManagedInstanceKeyPlainArgs):
        GetManagedInstanceKeyResult =
        getManagedInstanceKeyResultToKotlin(getManagedInstanceKeyPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstanceKey].
     * @param keyName The name of the managed instance key to be retrieved.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A managed instance key.
     */
    public suspend fun getManagedInstanceKey(
        keyName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedInstanceKeyResult {
        val argument = GetManagedInstanceKeyPlainArgs(
            keyName = keyName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstanceKeyResultToKotlin(getManagedInstanceKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstanceKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstanceKeyPlainArgs].
     * @return A managed instance key.
     */
    public suspend
    fun getManagedInstanceKey(argument: suspend GetManagedInstanceKeyPlainArgsBuilder.() -> Unit):
        GetManagedInstanceKeyResult {
        val builder = GetManagedInstanceKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceKeyResultToKotlin(getManagedInstanceKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed database's long term retention policy.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A long term retention policy.
     */
    public suspend
    fun getManagedInstanceLongTermRetentionPolicy(argument: GetManagedInstanceLongTermRetentionPolicyPlainArgs):
        GetManagedInstanceLongTermRetentionPolicyResult =
        getManagedInstanceLongTermRetentionPolicyResultToKotlin(getManagedInstanceLongTermRetentionPolicyPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstanceLongTermRetentionPolicy].
     * @param databaseName The name of the database.
     * @param managedInstanceName The name of the managed instance.
     * @param policyName The policy name. Should always be Default.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A long term retention policy.
     */
    public suspend fun getManagedInstanceLongTermRetentionPolicy(
        databaseName: String,
        managedInstanceName: String,
        policyName: String,
        resourceGroupName: String,
    ): GetManagedInstanceLongTermRetentionPolicyResult {
        val argument = GetManagedInstanceLongTermRetentionPolicyPlainArgs(
            databaseName = databaseName,
            managedInstanceName = managedInstanceName,
            policyName = policyName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstanceLongTermRetentionPolicyResultToKotlin(getManagedInstanceLongTermRetentionPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstanceLongTermRetentionPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstanceLongTermRetentionPolicyPlainArgs].
     * @return A long term retention policy.
     */
    public suspend
    fun getManagedInstanceLongTermRetentionPolicy(argument: suspend GetManagedInstanceLongTermRetentionPolicyPlainArgsBuilder.() -> Unit):
        GetManagedInstanceLongTermRetentionPolicyResult {
        val builder = GetManagedInstanceLongTermRetentionPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceLongTermRetentionPolicyResultToKotlin(getManagedInstanceLongTermRetentionPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend
    fun getManagedInstancePrivateEndpointConnection(argument: GetManagedInstancePrivateEndpointConnectionPlainArgs):
        GetManagedInstancePrivateEndpointConnectionResult =
        getManagedInstancePrivateEndpointConnectionResultToKotlin(getManagedInstancePrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstancePrivateEndpointConnection].
     * @param managedInstanceName The name of the managed instance.
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A private endpoint connection
     */
    public suspend fun getManagedInstancePrivateEndpointConnection(
        managedInstanceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetManagedInstancePrivateEndpointConnectionResult {
        val argument = GetManagedInstancePrivateEndpointConnectionPlainArgs(
            managedInstanceName = managedInstanceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedInstancePrivateEndpointConnectionResultToKotlin(getManagedInstancePrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstancePrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstancePrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getManagedInstancePrivateEndpointConnection(argument: suspend GetManagedInstancePrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetManagedInstancePrivateEndpointConnectionResult {
        val builder = GetManagedInstancePrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstancePrivateEndpointConnectionResultToKotlin(getManagedInstancePrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the managed instance's vulnerability assessment.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A managed instance vulnerability assessment.
     */
    public suspend
    fun getManagedInstanceVulnerabilityAssessment(argument: GetManagedInstanceVulnerabilityAssessmentPlainArgs):
        GetManagedInstanceVulnerabilityAssessmentResult =
        getManagedInstanceVulnerabilityAssessmentResultToKotlin(getManagedInstanceVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getManagedInstanceVulnerabilityAssessment].
     * @param managedInstanceName The name of the managed instance for which the vulnerability assessment is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A managed instance vulnerability assessment.
     */
    public suspend fun getManagedInstanceVulnerabilityAssessment(
        managedInstanceName: String,
        resourceGroupName: String,
        vulnerabilityAssessmentName: String,
    ): GetManagedInstanceVulnerabilityAssessmentResult {
        val argument = GetManagedInstanceVulnerabilityAssessmentPlainArgs(
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getManagedInstanceVulnerabilityAssessmentResultToKotlin(getManagedInstanceVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedInstanceVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedInstanceVulnerabilityAssessmentPlainArgs].
     * @return A managed instance vulnerability assessment.
     */
    public suspend
    fun getManagedInstanceVulnerabilityAssessment(argument: suspend GetManagedInstanceVulnerabilityAssessmentPlainArgsBuilder.() -> Unit):
        GetManagedInstanceVulnerabilityAssessmentResult {
        val builder = GetManagedInstanceVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedInstanceVulnerabilityAssessmentResultToKotlin(getManagedInstanceVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server DNS alias.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A managed server DNS alias.
     */
    public suspend fun getManagedServerDnsAlias(argument: GetManagedServerDnsAliasPlainArgs):
        GetManagedServerDnsAliasResult =
        getManagedServerDnsAliasResultToKotlin(getManagedServerDnsAliasPlain(argument.toJava()).await())

    /**
     * @see [getManagedServerDnsAlias].
     * @param dnsAliasName
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return A managed server DNS alias.
     */
    public suspend fun getManagedServerDnsAlias(
        dnsAliasName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetManagedServerDnsAliasResult {
        val argument = GetManagedServerDnsAliasPlainArgs(
            dnsAliasName = dnsAliasName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedServerDnsAliasResultToKotlin(getManagedServerDnsAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedServerDnsAlias].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetManagedServerDnsAliasPlainArgs].
     * @return A managed server DNS alias.
     */
    public suspend
    fun getManagedServerDnsAlias(argument: suspend GetManagedServerDnsAliasPlainArgsBuilder.() -> Unit):
        GetManagedServerDnsAliasResult {
        val builder = GetManagedServerDnsAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedServerDnsAliasResultToKotlin(getManagedServerDnsAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an outbound firewall rule.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL DB Server Outbound Firewall Rule.
     */
    public suspend fun getOutboundFirewallRule(argument: GetOutboundFirewallRulePlainArgs):
        GetOutboundFirewallRuleResult =
        getOutboundFirewallRuleResultToKotlin(getOutboundFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getOutboundFirewallRule].
     * @param outboundRuleFqdn
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An Azure SQL DB Server Outbound Firewall Rule.
     */
    public suspend fun getOutboundFirewallRule(
        outboundRuleFqdn: String,
        resourceGroupName: String,
        serverName: String,
    ): GetOutboundFirewallRuleResult {
        val argument = GetOutboundFirewallRulePlainArgs(
            outboundRuleFqdn = outboundRuleFqdn,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getOutboundFirewallRuleResultToKotlin(getOutboundFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getOutboundFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetOutboundFirewallRulePlainArgs].
     * @return An Azure SQL DB Server Outbound Firewall Rule.
     */
    public suspend
    fun getOutboundFirewallRule(argument: suspend GetOutboundFirewallRulePlainArgsBuilder.() -> Unit):
        GetOutboundFirewallRuleResult {
        val builder = GetOutboundFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOutboundFirewallRuleResultToKotlin(getOutboundFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A private endpoint connection
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return A private endpoint connection
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a replication link.
     * Azure REST API version: 2023-05-01-preview.
     * @param argument null
     * @return A replication link.
     */
    public suspend fun getReplicationLink(argument: GetReplicationLinkPlainArgs):
        GetReplicationLinkResult =
        getReplicationLinkResultToKotlin(getReplicationLinkPlain(argument.toJava()).await())

    /**
     * @see [getReplicationLink].
     * @param databaseName The name of the database.
     * @param linkId The name of the replication link.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A replication link.
     */
    public suspend fun getReplicationLink(
        databaseName: String,
        linkId: String,
        resourceGroupName: String,
        serverName: String,
    ): GetReplicationLinkResult {
        val argument = GetReplicationLinkPlainArgs(
            databaseName = databaseName,
            linkId = linkId,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getReplicationLinkResultToKotlin(getReplicationLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getReplicationLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetReplicationLinkPlainArgs].
     * @return A replication link.
     */
    public suspend
    fun getReplicationLink(argument: suspend GetReplicationLinkPlainArgsBuilder.() -> Unit):
        GetReplicationLinkResult {
        val builder = GetReplicationLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReplicationLinkResultToKotlin(getReplicationLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the sensitivity label of a given column
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A sensitivity label.
     */
    public suspend fun getSensitivityLabel(argument: GetSensitivityLabelPlainArgs):
        GetSensitivityLabelResult =
        getSensitivityLabelResultToKotlin(getSensitivityLabelPlain(argument.toJava()).await())

    /**
     * @see [getSensitivityLabel].
     * @param columnName The name of the column.
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param schemaName The name of the schema.
     * @param sensitivityLabelSource The source of the sensitivity label.
     * @param serverName The name of the server.
     * @param tableName The name of the table.
     * @return A sensitivity label.
     */
    public suspend fun getSensitivityLabel(
        columnName: String,
        databaseName: String,
        resourceGroupName: String,
        schemaName: String,
        sensitivityLabelSource: String,
        serverName: String,
        tableName: String,
    ): GetSensitivityLabelResult {
        val argument = GetSensitivityLabelPlainArgs(
            columnName = columnName,
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            schemaName = schemaName,
            sensitivityLabelSource = sensitivityLabelSource,
            serverName = serverName,
            tableName = tableName,
        )
        return getSensitivityLabelResultToKotlin(getSensitivityLabelPlain(argument.toJava()).await())
    }

    /**
     * @see [getSensitivityLabel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSensitivityLabelPlainArgs].
     * @return A sensitivity label.
     */
    public suspend
    fun getSensitivityLabel(argument: suspend GetSensitivityLabelPlainArgsBuilder.() -> Unit):
        GetSensitivityLabelResult {
        val builder = GetSensitivityLabelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSensitivityLabelResultToKotlin(getSensitivityLabelPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL Database server.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        getServerResultToKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param expand The child resources to include in the response.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return An Azure SQL Database server.
     */
    public suspend fun getServer(
        expand: String? = null,
        resourceGroupName: String,
        serverName: String,
    ): GetServerResult {
        val argument = GetServerPlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerResultToKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return An Azure SQL Database server.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit):
        GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerResultToKotlin(getServerPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server advisor.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend fun getServerAdvisor(argument: GetServerAdvisorPlainArgs): GetServerAdvisorResult =
        getServerAdvisorResultToKotlin(getServerAdvisorPlain(argument.toJava()).await())

    /**
     * @see [getServerAdvisor].
     * @param advisorName The name of the Server Advisor.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend fun getServerAdvisor(
        advisorName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerAdvisorResult {
        val argument = GetServerAdvisorPlainArgs(
            advisorName = advisorName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerAdvisorResultToKotlin(getServerAdvisorPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerAdvisor].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerAdvisorPlainArgs].
     * @return Database, Server or Elastic Pool Advisor.
     */
    public suspend
    fun getServerAdvisor(argument: suspend GetServerAdvisorPlainArgsBuilder.() -> Unit):
        GetServerAdvisorResult {
        val builder = GetServerAdvisorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerAdvisorResultToKotlin(getServerAdvisorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Azure Active Directory administrator.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Azure Active Directory administrator.
     */
    public suspend
    fun getServerAzureADAdministrator(argument: GetServerAzureADAdministratorPlainArgs):
        GetServerAzureADAdministratorResult =
        getServerAzureADAdministratorResultToKotlin(getServerAzureADAdministratorPlain(argument.toJava()).await())

    /**
     * @see [getServerAzureADAdministrator].
     * @param administratorName The name of server active directory administrator.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Azure Active Directory administrator.
     */
    public suspend fun getServerAzureADAdministrator(
        administratorName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerAzureADAdministratorResult {
        val argument = GetServerAzureADAdministratorPlainArgs(
            administratorName = administratorName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerAzureADAdministratorResultToKotlin(getServerAzureADAdministratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerAzureADAdministrator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerAzureADAdministratorPlainArgs].
     * @return Azure Active Directory administrator.
     */
    public suspend
    fun getServerAzureADAdministrator(argument: suspend GetServerAzureADAdministratorPlainArgsBuilder.() -> Unit):
        GetServerAzureADAdministratorResult {
        val builder = GetServerAzureADAdministratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerAzureADAdministratorResultToKotlin(getServerAzureADAdministratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a specific Azure Active Directory only authentication property.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Azure Active Directory only authentication.
     */
    public suspend
    fun getServerAzureADOnlyAuthentication(argument: GetServerAzureADOnlyAuthenticationPlainArgs):
        GetServerAzureADOnlyAuthenticationResult =
        getServerAzureADOnlyAuthenticationResultToKotlin(getServerAzureADOnlyAuthenticationPlain(argument.toJava()).await())

    /**
     * @see [getServerAzureADOnlyAuthentication].
     * @param authenticationName The name of server azure active directory only authentication.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Azure Active Directory only authentication.
     */
    public suspend fun getServerAzureADOnlyAuthentication(
        authenticationName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerAzureADOnlyAuthenticationResult {
        val argument = GetServerAzureADOnlyAuthenticationPlainArgs(
            authenticationName = authenticationName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerAzureADOnlyAuthenticationResultToKotlin(getServerAzureADOnlyAuthenticationPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerAzureADOnlyAuthentication].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerAzureADOnlyAuthenticationPlainArgs].
     * @return Azure Active Directory only authentication.
     */
    public suspend
    fun getServerAzureADOnlyAuthentication(argument: suspend GetServerAzureADOnlyAuthenticationPlainArgsBuilder.() -> Unit):
        GetServerAzureADOnlyAuthenticationResult {
        val builder = GetServerAzureADOnlyAuthenticationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerAzureADOnlyAuthenticationResultToKotlin(getServerAzureADOnlyAuthenticationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server's blob auditing policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server blob auditing policy.
     */
    public suspend fun getServerBlobAuditingPolicy(argument: GetServerBlobAuditingPolicyPlainArgs):
        GetServerBlobAuditingPolicyResult =
        getServerBlobAuditingPolicyResultToKotlin(getServerBlobAuditingPolicyPlain(argument.toJava()).await())

    /**
     * @see [getServerBlobAuditingPolicy].
     * @param blobAuditingPolicyName The name of the blob auditing policy.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A server blob auditing policy.
     */
    public suspend fun getServerBlobAuditingPolicy(
        blobAuditingPolicyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerBlobAuditingPolicyResult {
        val argument = GetServerBlobAuditingPolicyPlainArgs(
            blobAuditingPolicyName = blobAuditingPolicyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerBlobAuditingPolicyResultToKotlin(getServerBlobAuditingPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerBlobAuditingPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerBlobAuditingPolicyPlainArgs].
     * @return A server blob auditing policy.
     */
    public suspend
    fun getServerBlobAuditingPolicy(argument: suspend GetServerBlobAuditingPolicyPlainArgsBuilder.() -> Unit):
        GetServerBlobAuditingPolicyResult {
        val builder = GetServerBlobAuditingPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerBlobAuditingPolicyResultToKotlin(getServerBlobAuditingPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a server communication link.
     * Azure REST API version: 2014-04-01.
     * @param argument null
     * @return Server communication link.
     */
    public suspend fun getServerCommunicationLink(argument: GetServerCommunicationLinkPlainArgs):
        GetServerCommunicationLinkResult =
        getServerCommunicationLinkResultToKotlin(getServerCommunicationLinkPlain(argument.toJava()).await())

    /**
     * @see [getServerCommunicationLink].
     * @param communicationLinkName The name of the server communication link.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return Server communication link.
     */
    public suspend fun getServerCommunicationLink(
        communicationLinkName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerCommunicationLinkResult {
        val argument = GetServerCommunicationLinkPlainArgs(
            communicationLinkName = communicationLinkName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerCommunicationLinkResultToKotlin(getServerCommunicationLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerCommunicationLink].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerCommunicationLinkPlainArgs].
     * @return Server communication link.
     */
    public suspend
    fun getServerCommunicationLink(argument: suspend GetServerCommunicationLinkPlainArgsBuilder.() -> Unit):
        GetServerCommunicationLinkResult {
        val builder = GetServerCommunicationLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerCommunicationLinkResultToKotlin(getServerCommunicationLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server DNS alias.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server DNS alias.
     */
    public suspend fun getServerDnsAlias(argument: GetServerDnsAliasPlainArgs):
        GetServerDnsAliasResult =
        getServerDnsAliasResultToKotlin(getServerDnsAliasPlain(argument.toJava()).await())

    /**
     * @see [getServerDnsAlias].
     * @param dnsAliasName The name of the server dns alias.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server that the alias is pointing to.
     * @return A server DNS alias.
     */
    public suspend fun getServerDnsAlias(
        dnsAliasName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerDnsAliasResult {
        val argument = GetServerDnsAliasPlainArgs(
            dnsAliasName = dnsAliasName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerDnsAliasResultToKotlin(getServerDnsAliasPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerDnsAlias].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerDnsAliasPlainArgs].
     * @return A server DNS alias.
     */
    public suspend
    fun getServerDnsAlias(argument: suspend GetServerDnsAliasPlainArgsBuilder.() -> Unit):
        GetServerDnsAliasResult {
        val builder = GetServerDnsAliasPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerDnsAliasResultToKotlin(getServerDnsAliasPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server key.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2015-05-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server key.
     */
    public suspend fun getServerKey(argument: GetServerKeyPlainArgs): GetServerKeyResult =
        getServerKeyResultToKotlin(getServerKeyPlain(argument.toJava()).await())

    /**
     * @see [getServerKey].
     * @param keyName The name of the server key to be retrieved.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @return A server key.
     */
    public suspend fun getServerKey(
        keyName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetServerKeyResult {
        val argument = GetServerKeyPlainArgs(
            keyName = keyName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerKeyResultToKotlin(getServerKeyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerKey].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerKeyPlainArgs].
     * @return A server key.
     */
    public suspend fun getServerKey(argument: suspend GetServerKeyPlainArgsBuilder.() -> Unit):
        GetServerKeyResult {
        val builder = GetServerKeyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerKeyResultToKotlin(getServerKeyPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a server's security alert policy.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2017-03-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server security alert policy.
     */
    public suspend fun getServerSecurityAlertPolicy(argument: GetServerSecurityAlertPolicyPlainArgs):
        GetServerSecurityAlertPolicyResult =
        getServerSecurityAlertPolicyResultToKotlin(getServerSecurityAlertPolicyPlain(argument.toJava()).await())

    /**
     * @see [getServerSecurityAlertPolicy].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param securityAlertPolicyName The name of the security alert policy.
     * @param serverName The name of the server.
     * @return A server security alert policy.
     */
    public suspend fun getServerSecurityAlertPolicy(
        resourceGroupName: String,
        securityAlertPolicyName: String,
        serverName: String,
    ): GetServerSecurityAlertPolicyResult {
        val argument = GetServerSecurityAlertPolicyPlainArgs(
            resourceGroupName = resourceGroupName,
            securityAlertPolicyName = securityAlertPolicyName,
            serverName = serverName,
        )
        return getServerSecurityAlertPolicyResultToKotlin(getServerSecurityAlertPolicyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerSecurityAlertPolicy].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerSecurityAlertPolicyPlainArgs].
     * @return A server security alert policy.
     */
    public suspend
    fun getServerSecurityAlertPolicy(argument: suspend GetServerSecurityAlertPolicyPlainArgsBuilder.() -> Unit):
        GetServerSecurityAlertPolicyResult {
        val builder = GetServerSecurityAlertPolicyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerSecurityAlertPolicyResultToKotlin(getServerSecurityAlertPolicyPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server trust certificate that was uploaded from box to Sql Managed Instance.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
     */
    public suspend fun getServerTrustCertificate(argument: GetServerTrustCertificatePlainArgs):
        GetServerTrustCertificateResult =
        getServerTrustCertificateResultToKotlin(getServerTrustCertificatePlain(argument.toJava()).await())

    /**
     * @see [getServerTrustCertificate].
     * @param certificateName Name of of the certificate to get.
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @return Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
     */
    public suspend fun getServerTrustCertificate(
        certificateName: String,
        managedInstanceName: String,
        resourceGroupName: String,
    ): GetServerTrustCertificateResult {
        val argument = GetServerTrustCertificatePlainArgs(
            certificateName = certificateName,
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
        )
        return getServerTrustCertificateResultToKotlin(getServerTrustCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getServerTrustCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerTrustCertificatePlainArgs].
     * @return Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
     */
    public suspend
    fun getServerTrustCertificate(argument: suspend GetServerTrustCertificatePlainArgsBuilder.() -> Unit):
        GetServerTrustCertificateResult {
        val builder = GetServerTrustCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerTrustCertificateResultToKotlin(getServerTrustCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a server trust group.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server trust group.
     */
    public suspend fun getServerTrustGroup(argument: GetServerTrustGroupPlainArgs):
        GetServerTrustGroupResult =
        getServerTrustGroupResultToKotlin(getServerTrustGroupPlain(argument.toJava()).await())

    /**
     * @see [getServerTrustGroup].
     * @param locationName The name of the region where the resource is located.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverTrustGroupName The name of the server trust group.
     * @return A server trust group.
     */
    public suspend fun getServerTrustGroup(
        locationName: String,
        resourceGroupName: String,
        serverTrustGroupName: String,
    ): GetServerTrustGroupResult {
        val argument = GetServerTrustGroupPlainArgs(
            locationName = locationName,
            resourceGroupName = resourceGroupName,
            serverTrustGroupName = serverTrustGroupName,
        )
        return getServerTrustGroupResultToKotlin(getServerTrustGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerTrustGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerTrustGroupPlainArgs].
     * @return A server trust group.
     */
    public suspend
    fun getServerTrustGroup(argument: suspend GetServerTrustGroupPlainArgsBuilder.() -> Unit):
        GetServerTrustGroupResult {
        val builder = GetServerTrustGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerTrustGroupResultToKotlin(getServerTrustGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the server's vulnerability assessment.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A server vulnerability assessment.
     */
    public suspend
    fun getServerVulnerabilityAssessment(argument: GetServerVulnerabilityAssessmentPlainArgs):
        GetServerVulnerabilityAssessmentResult =
        getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(argument.toJava()).await())

    /**
     * @see [getServerVulnerabilityAssessment].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server for which the vulnerability assessment is defined.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A server vulnerability assessment.
     */
    public suspend fun getServerVulnerabilityAssessment(
        resourceGroupName: String,
        serverName: String,
        vulnerabilityAssessmentName: String,
    ): GetServerVulnerabilityAssessmentResult {
        val argument = GetServerVulnerabilityAssessmentPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getServerVulnerabilityAssessment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetServerVulnerabilityAssessmentPlainArgs].
     * @return A server vulnerability assessment.
     */
    public suspend
    fun getServerVulnerabilityAssessment(argument: suspend GetServerVulnerabilityAssessmentPlainArgsBuilder.() -> Unit):
        GetServerVulnerabilityAssessmentResult {
        val builder = GetServerVulnerabilityAssessmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerVulnerabilityAssessmentResultToKotlin(getServerVulnerabilityAssessmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a system database's sql vulnerability assessment rule baseline.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentRuleBaseline(argument: GetSqlVulnerabilityAssessmentRuleBaselinePlainArgs):
        GetSqlVulnerabilityAssessmentRuleBaselineResult =
        getSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())

    /**
     * @see [getSqlVulnerabilityAssessmentRuleBaseline].
     * @param baselineName
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param ruleId The vulnerability assessment rule ID.
     * @param serverName The name of the server.
     * @param systemDatabaseName The vulnerability assessment system database name.
     * @param vulnerabilityAssessmentName The name of the vulnerability assessment.
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend fun getSqlVulnerabilityAssessmentRuleBaseline(
        baselineName: String,
        resourceGroupName: String,
        ruleId: String,
        serverName: String,
        systemDatabaseName: String,
        vulnerabilityAssessmentName: String,
    ): GetSqlVulnerabilityAssessmentRuleBaselineResult {
        val argument = GetSqlVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName,
            resourceGroupName = resourceGroupName,
            ruleId = ruleId,
            serverName = serverName,
            systemDatabaseName = systemDatabaseName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlVulnerabilityAssessmentRuleBaselinePlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlVulnerabilityAssessmentRuleBaseline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSqlVulnerabilityAssessmentRuleBaselinePlainArgs].
     * @return A database sql vulnerability assessment rule baseline.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentRuleBaseline(argument: suspend GetSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder.() -> Unit):
        GetSqlVulnerabilityAssessmentRuleBaselineResult {
        val builder = GetSqlVulnerabilityAssessmentRuleBaselinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlVulnerabilityAssessmentRuleBaselineResultToKotlin(getSqlVulnerabilityAssessmentRuleBaselinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets SQL Vulnerability Assessment policy.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A SQL Vulnerability Assessment.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentsSetting(argument: GetSqlVulnerabilityAssessmentsSettingPlainArgs):
        GetSqlVulnerabilityAssessmentsSettingResult =
        getSqlVulnerabilityAssessmentsSettingResultToKotlin(getSqlVulnerabilityAssessmentsSettingPlain(argument.toJava()).await())

    /**
     * @see [getSqlVulnerabilityAssessmentsSetting].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param vulnerabilityAssessmentName The name of the SQL Vulnerability Assessment.
     * @return A SQL Vulnerability Assessment.
     */
    public suspend fun getSqlVulnerabilityAssessmentsSetting(
        resourceGroupName: String,
        serverName: String,
        vulnerabilityAssessmentName: String,
    ): GetSqlVulnerabilityAssessmentsSettingResult {
        val argument = GetSqlVulnerabilityAssessmentsSettingPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            vulnerabilityAssessmentName = vulnerabilityAssessmentName,
        )
        return getSqlVulnerabilityAssessmentsSettingResultToKotlin(getSqlVulnerabilityAssessmentsSettingPlain(argument.toJava()).await())
    }

    /**
     * @see [getSqlVulnerabilityAssessmentsSetting].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSqlVulnerabilityAssessmentsSettingPlainArgs].
     * @return A SQL Vulnerability Assessment.
     */
    public suspend
    fun getSqlVulnerabilityAssessmentsSetting(argument: suspend GetSqlVulnerabilityAssessmentsSettingPlainArgsBuilder.() -> Unit):
        GetSqlVulnerabilityAssessmentsSettingResult {
        val builder = GetSqlVulnerabilityAssessmentsSettingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSqlVulnerabilityAssessmentsSettingResultToKotlin(getSqlVulnerabilityAssessmentsSettingPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the managed instance's Start/Stop schedule.
     * Azure REST API version: 2022-11-01-preview.
     * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Managed instance's Start/Stop schedule.
     */
    public suspend
    fun getStartStopManagedInstanceSchedule(argument: GetStartStopManagedInstanceSchedulePlainArgs):
        GetStartStopManagedInstanceScheduleResult =
        getStartStopManagedInstanceScheduleResultToKotlin(getStartStopManagedInstanceSchedulePlain(argument.toJava()).await())

    /**
     * @see [getStartStopManagedInstanceSchedule].
     * @param managedInstanceName The name of the managed instance.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param startStopScheduleName Name of the managed instance Start/Stop schedule.
     * @return Managed instance's Start/Stop schedule.
     */
    public suspend fun getStartStopManagedInstanceSchedule(
        managedInstanceName: String,
        resourceGroupName: String,
        startStopScheduleName: String,
    ): GetStartStopManagedInstanceScheduleResult {
        val argument = GetStartStopManagedInstanceSchedulePlainArgs(
            managedInstanceName = managedInstanceName,
            resourceGroupName = resourceGroupName,
            startStopScheduleName = startStopScheduleName,
        )
        return getStartStopManagedInstanceScheduleResultToKotlin(getStartStopManagedInstanceSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getStartStopManagedInstanceSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetStartStopManagedInstanceSchedulePlainArgs].
     * @return Managed instance's Start/Stop schedule.
     */
    public suspend
    fun getStartStopManagedInstanceSchedule(argument: suspend GetStartStopManagedInstanceSchedulePlainArgsBuilder.() -> Unit):
        GetStartStopManagedInstanceScheduleResult {
        val builder = GetStartStopManagedInstanceSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStartStopManagedInstanceScheduleResultToKotlin(getStartStopManagedInstanceSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a sync agent.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL Database sync agent.
     */
    public suspend fun getSyncAgent(argument: GetSyncAgentPlainArgs): GetSyncAgentResult =
        getSyncAgentResultToKotlin(getSyncAgentPlain(argument.toJava()).await())

    /**
     * @see [getSyncAgent].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server on which the sync agent is hosted.
     * @param syncAgentName The name of the sync agent.
     * @return An Azure SQL Database sync agent.
     */
    public suspend fun getSyncAgent(
        resourceGroupName: String,
        serverName: String,
        syncAgentName: String,
    ): GetSyncAgentResult {
        val argument = GetSyncAgentPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            syncAgentName = syncAgentName,
        )
        return getSyncAgentResultToKotlin(getSyncAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getSyncAgent].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSyncAgentPlainArgs].
     * @return An Azure SQL Database sync agent.
     */
    public suspend fun getSyncAgent(argument: suspend GetSyncAgentPlainArgsBuilder.() -> Unit):
        GetSyncAgentResult {
        val builder = GetSyncAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSyncAgentResultToKotlin(getSyncAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a sync group.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL Database sync group.
     */
    public suspend fun getSyncGroup(argument: GetSyncGroupPlainArgs): GetSyncGroupResult =
        getSyncGroupResultToKotlin(getSyncGroupPlain(argument.toJava()).await())

    /**
     * @see [getSyncGroup].
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param syncGroupName The name of the sync group.
     * @return An Azure SQL Database sync group.
     */
    public suspend fun getSyncGroup(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        syncGroupName: String,
    ): GetSyncGroupResult {
        val argument = GetSyncGroupPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            syncGroupName = syncGroupName,
        )
        return getSyncGroupResultToKotlin(getSyncGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSyncGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSyncGroupPlainArgs].
     * @return An Azure SQL Database sync group.
     */
    public suspend fun getSyncGroup(argument: suspend GetSyncGroupPlainArgsBuilder.() -> Unit):
        GetSyncGroupResult {
        val builder = GetSyncGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSyncGroupResultToKotlin(getSyncGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a sync member.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return An Azure SQL Database sync member.
     */
    public suspend fun getSyncMember(argument: GetSyncMemberPlainArgs): GetSyncMemberResult =
        getSyncMemberResultToKotlin(getSyncMemberPlain(argument.toJava()).await())

    /**
     * @see [getSyncMember].
     * @param databaseName The name of the database on which the sync group is hosted.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param syncGroupName The name of the sync group on which the sync member is hosted.
     * @param syncMemberName The name of the sync member.
     * @return An Azure SQL Database sync member.
     */
    public suspend fun getSyncMember(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        syncGroupName: String,
        syncMemberName: String,
    ): GetSyncMemberResult {
        val argument = GetSyncMemberPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            syncGroupName = syncGroupName,
            syncMemberName = syncMemberName,
        )
        return getSyncMemberResultToKotlin(getSyncMemberPlain(argument.toJava()).await())
    }

    /**
     * @see [getSyncMember].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetSyncMemberPlainArgs].
     * @return An Azure SQL Database sync member.
     */
    public suspend fun getSyncMember(argument: suspend GetSyncMemberPlainArgsBuilder.() -> Unit):
        GetSyncMemberResult {
        val builder = GetSyncMemberPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSyncMemberResultToKotlin(getSyncMemberPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a logical database's transparent data encryption.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A logical database transparent data encryption state.
     */
    public suspend fun getTransparentDataEncryption(argument: GetTransparentDataEncryptionPlainArgs):
        GetTransparentDataEncryptionResult =
        getTransparentDataEncryptionResultToKotlin(getTransparentDataEncryptionPlain(argument.toJava()).await())

    /**
     * @see [getTransparentDataEncryption].
     * @param databaseName The name of the logical database for which the transparent data encryption is defined.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param tdeName The name of the transparent data encryption configuration.
     * @return A logical database transparent data encryption state.
     */
    public suspend fun getTransparentDataEncryption(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        tdeName: String,
    ): GetTransparentDataEncryptionResult {
        val argument = GetTransparentDataEncryptionPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            tdeName = tdeName,
        )
        return getTransparentDataEncryptionResultToKotlin(getTransparentDataEncryptionPlain(argument.toJava()).await())
    }

    /**
     * @see [getTransparentDataEncryption].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetTransparentDataEncryptionPlainArgs].
     * @return A logical database transparent data encryption state.
     */
    public suspend
    fun getTransparentDataEncryption(argument: suspend GetTransparentDataEncryptionPlainArgsBuilder.() -> Unit):
        GetTransparentDataEncryptionResult {
        val builder = GetTransparentDataEncryptionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTransparentDataEncryptionResultToKotlin(getTransparentDataEncryptionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a virtual network rule.
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return A virtual network rule.
     */
    public suspend fun getVirtualNetworkRule(argument: GetVirtualNetworkRulePlainArgs):
        GetVirtualNetworkRuleResult =
        getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(argument.toJava()).await())

    /**
     * @see [getVirtualNetworkRule].
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param virtualNetworkRuleName The name of the virtual network rule.
     * @return A virtual network rule.
     */
    public suspend fun getVirtualNetworkRule(
        resourceGroupName: String,
        serverName: String,
        virtualNetworkRuleName: String,
    ): GetVirtualNetworkRuleResult {
        val argument = GetVirtualNetworkRulePlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            virtualNetworkRuleName = virtualNetworkRuleName,
        )
        return getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualNetworkRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetVirtualNetworkRulePlainArgs].
     * @return A virtual network rule.
     */
    public suspend
    fun getVirtualNetworkRule(argument: suspend GetVirtualNetworkRulePlainArgsBuilder.() -> Unit):
        GetVirtualNetworkRuleResult {
        val builder = GetVirtualNetworkRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualNetworkRuleResultToKotlin(getVirtualNetworkRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workload classifier
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Workload classifier operations for a data warehouse
     */
    public suspend fun getWorkloadClassifier(argument: GetWorkloadClassifierPlainArgs):
        GetWorkloadClassifierResult =
        getWorkloadClassifierResultToKotlin(getWorkloadClassifierPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadClassifier].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param workloadClassifierName The name of the workload classifier.
     * @param workloadGroupName The name of the workload group from which to receive the classifier from.
     * @return Workload classifier operations for a data warehouse
     */
    public suspend fun getWorkloadClassifier(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        workloadClassifierName: String,
        workloadGroupName: String,
    ): GetWorkloadClassifierResult {
        val argument = GetWorkloadClassifierPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            workloadClassifierName = workloadClassifierName,
            workloadGroupName = workloadGroupName,
        )
        return getWorkloadClassifierResultToKotlin(getWorkloadClassifierPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadClassifier].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetWorkloadClassifierPlainArgs].
     * @return Workload classifier operations for a data warehouse
     */
    public suspend
    fun getWorkloadClassifier(argument: suspend GetWorkloadClassifierPlainArgsBuilder.() -> Unit):
        GetWorkloadClassifierResult {
        val builder = GetWorkloadClassifierPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadClassifierResultToKotlin(getWorkloadClassifierPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a workload group
     * Azure REST API version: 2021-11-01.
     * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
     * @param argument null
     * @return Workload group operations for a data warehouse
     */
    public suspend fun getWorkloadGroup(argument: GetWorkloadGroupPlainArgs): GetWorkloadGroupResult =
        getWorkloadGroupResultToKotlin(getWorkloadGroupPlain(argument.toJava()).await())

    /**
     * @see [getWorkloadGroup].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     * @param serverName The name of the server.
     * @param workloadGroupName The name of the workload group.
     * @return Workload group operations for a data warehouse
     */
    public suspend fun getWorkloadGroup(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
        workloadGroupName: String,
    ): GetWorkloadGroupResult {
        val argument = GetWorkloadGroupPlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
            workloadGroupName = workloadGroupName,
        )
        return getWorkloadGroupResultToKotlin(getWorkloadGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkloadGroup].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;sql&#46;kotlin&#46;inputs&#46;GetWorkloadGroupPlainArgs].
     * @return Workload group operations for a data warehouse
     */
    public suspend
    fun getWorkloadGroup(argument: suspend GetWorkloadGroupPlainArgsBuilder.() -> Unit):
        GetWorkloadGroupResult {
        val builder = GetWorkloadGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkloadGroupResultToKotlin(getWorkloadGroupPlain(builtArgument.toJava()).await())
    }
}
