@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.SyncAgentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure SQL Database sync agent.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a new sync agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncAgent = new AzureNative.Sql.SyncAgent("syncAgent", new()
 *     {
 *         ResourceGroupName = "syncagentcrud-65440",
 *         ServerName = "syncagentcrud-8475",
 *         SyncAgentName = "syncagentcrud-3187",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncAgent(ctx, "syncAgent", &sql.SyncAgentArgs{
 * 			ResourceGroupName: pulumi.String("syncagentcrud-65440"),
 * 			ServerName:        pulumi.String("syncagentcrud-8475"),
 * 			SyncAgentName:     pulumi.String("syncagentcrud-3187"),
 * 			SyncDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncAgent;
 * import com.pulumi.azurenative.sql.SyncAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncAgent = new SyncAgent("syncAgent", SyncAgentArgs.builder()
 *             .resourceGroupName("syncagentcrud-65440")
 *             .serverName("syncagentcrud-8475")
 *             .syncAgentName("syncagentcrud-3187")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync agent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncAgent = new AzureNative.Sql.SyncAgent("syncAgent", new()
 *     {
 *         ResourceGroupName = "syncagentcrud-65440",
 *         ServerName = "syncagentcrud-8475",
 *         SyncAgentName = "syncagentcrud-3187",
 *         SyncDatabaseId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncAgent(ctx, "syncAgent", &sql.SyncAgentArgs{
 * 			ResourceGroupName: pulumi.String("syncagentcrud-65440"),
 * 			ServerName:        pulumi.String("syncagentcrud-8475"),
 * 			SyncAgentName:     pulumi.String("syncagentcrud-3187"),
 * 			SyncDatabaseId:    pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncAgent;
 * import com.pulumi.azurenative.sql.SyncAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncAgent = new SyncAgent("syncAgent", SyncAgentArgs.builder()
 *             .resourceGroupName("syncagentcrud-65440")
 *             .serverName("syncagentcrud-8475")
 *             .syncAgentName("syncagentcrud-3187")
 *             .syncDatabaseId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default-SQL-Onebox/providers/Microsoft.Sql/servers/syncagentcrud-8475/databases/sync")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncAgent syncagent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/syncAgents/{syncAgentName}
 * ```
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server on which the sync agent is hosted.
 * @property syncAgentName The name of the sync agent.
 * @property syncDatabaseId ARM resource id of the sync database in the sync agent.
 */
public data class SyncAgentArgs(
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val syncAgentName: Output<String>? = null,
    public val syncDatabaseId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.SyncAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.SyncAgentArgs =
        com.pulumi.azurenative.sql.SyncAgentArgs.builder()
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .syncAgentName(syncAgentName?.applyValue({ args0 -> args0 }))
            .syncDatabaseId(syncDatabaseId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncAgentArgs].
 */
@PulumiTagMarker
public class SyncAgentArgsBuilder internal constructor() {
    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var syncAgentName: Output<String>? = null

    private var syncDatabaseId: Output<String>? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("tskbsupvrypqsoem")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server on which the sync agent is hosted.
     */
    @JvmName("upygbgpacyyhcqne")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the sync agent.
     */
    @JvmName("lrjldkekrqyijcqo")
    public suspend fun syncAgentName(`value`: Output<String>) {
        this.syncAgentName = value
    }

    /**
     * @param value ARM resource id of the sync database in the sync agent.
     */
    @JvmName("rbwiwbbgpwuobnmv")
    public suspend fun syncDatabaseId(`value`: Output<String>) {
        this.syncDatabaseId = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("txyvkjcatthrskby")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server on which the sync agent is hosted.
     */
    @JvmName("xeqoigksknpyrkby")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the sync agent.
     */
    @JvmName("tunfgrwbmsvfabdg")
    public suspend fun syncAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncAgentName = mapped
    }

    /**
     * @param value ARM resource id of the sync database in the sync agent.
     */
    @JvmName("fdvlgsvumumkvkcj")
    public suspend fun syncDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncDatabaseId = mapped
    }

    internal fun build(): SyncAgentArgs = SyncAgentArgs(
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        syncAgentName = syncAgentName,
        syncDatabaseId = syncDatabaseId,
    )
}
