@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.SyncMemberArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.SyncDirection
import com.pulumi.azurenative.sql.kotlin.enums.SyncMemberDbType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure SQL Database sync member.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a new sync member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncMember = new AzureNative.Sql.SyncMember("syncMember", new()
 *     {
 *         DatabaseName = "syncgroupcrud-7421",
 *         DatabaseType = "AzureSqlDatabase",
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDirection = "Bidirectional",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         SyncMemberAzureDatabaseResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncMemberName = "syncmembercrud-4879",
 *         UsePrivateLinkConnection = true,
 *         UserName = "myUser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncMember(ctx, "syncMember", &sql.SyncMemberArgs{
 * 			DatabaseName:                      pulumi.String("syncgroupcrud-7421"),
 * 			DatabaseType:                      pulumi.String("AzureSqlDatabase"),
 * 			ResourceGroupName:                 pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:                        pulumi.String("syncgroupcrud-8475"),
 * 			SyncDirection:                     pulumi.String("Bidirectional"),
 * 			SyncGroupName:                     pulumi.String("syncgroupcrud-3187"),
 * 			SyncMemberAzureDatabaseResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncMemberName:                    pulumi.String("syncmembercrud-4879"),
 * 			UsePrivateLinkConnection:          pulumi.Bool(true),
 * 			UserName:                          pulumi.String("myUser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncMember;
 * import com.pulumi.azurenative.sql.SyncMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncMember = new SyncMember("syncMember", SyncMemberArgs.builder()
 *             .databaseName("syncgroupcrud-7421")
 *             .databaseType("AzureSqlDatabase")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDirection("Bidirectional")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .syncMemberAzureDatabaseResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncMemberName("syncmembercrud-4879")
 *             .usePrivateLinkConnection(true)
 *             .userName("myUser")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncMember = new AzureNative.Sql.SyncMember("syncMember", new()
 *     {
 *         DatabaseName = "syncgroupcrud-7421",
 *         DatabaseType = "AzureSqlDatabase",
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDirection = "Bidirectional",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         SyncMemberAzureDatabaseResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncMemberName = "syncmembercrud-4879",
 *         UsePrivateLinkConnection = true,
 *         UserName = "myUser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncMember(ctx, "syncMember", &sql.SyncMemberArgs{
 * 			DatabaseName:                      pulumi.String("syncgroupcrud-7421"),
 * 			DatabaseType:                      pulumi.String("AzureSqlDatabase"),
 * 			ResourceGroupName:                 pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:                        pulumi.String("syncgroupcrud-8475"),
 * 			SyncDirection:                     pulumi.String("Bidirectional"),
 * 			SyncGroupName:                     pulumi.String("syncgroupcrud-3187"),
 * 			SyncMemberAzureDatabaseResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncMemberName:                    pulumi.String("syncmembercrud-4879"),
 * 			UsePrivateLinkConnection:          pulumi.Bool(true),
 * 			UserName:                          pulumi.String("myUser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncMember;
 * import com.pulumi.azurenative.sql.SyncMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncMember = new SyncMember("syncMember", SyncMemberArgs.builder()
 *             .databaseName("syncgroupcrud-7421")
 *             .databaseType("AzureSqlDatabase")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDirection("Bidirectional")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .syncMemberAzureDatabaseResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncMemberName("syncmembercrud-4879")
 *             .usePrivateLinkConnection(true)
 *             .userName("myUser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncMember syncmembercrud-4879 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}
 * ```
 * @property databaseName Database name of the member database in the sync member.
 * @property databaseType Database type of the sync member.
 * @property password Password of the member database in the sync member.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName Server name of the member database in the sync member
 * @property sqlServerDatabaseId SQL Server database id of the sync member.
 * @property syncAgentId ARM resource id of the sync agent in the sync member.
 * @property syncDirection Sync direction of the sync member.
 * @property syncGroupName The name of the sync group on which the sync member is hosted.
 * @property syncMemberAzureDatabaseResourceId ARM resource id of the sync member logical database, for sync members in Azure.
 * @property syncMemberName The name of the sync member.
 * @property usePrivateLinkConnection Whether to use private link connection.
 * @property userName User name of the member database in the sync member.
 */
public data class SyncMemberArgs(
    public val databaseName: Output<String>? = null,
    public val databaseType: Output<Either<String, SyncMemberDbType>>? = null,
    public val password: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sqlServerDatabaseId: Output<String>? = null,
    public val syncAgentId: Output<String>? = null,
    public val syncDirection: Output<Either<String, SyncDirection>>? = null,
    public val syncGroupName: Output<String>? = null,
    public val syncMemberAzureDatabaseResourceId: Output<String>? = null,
    public val syncMemberName: Output<String>? = null,
    public val usePrivateLinkConnection: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.SyncMemberArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.SyncMemberArgs =
        com.pulumi.azurenative.sql.SyncMemberArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .databaseType(
                databaseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .password(password?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sqlServerDatabaseId(sqlServerDatabaseId?.applyValue({ args0 -> args0 }))
            .syncAgentId(syncAgentId?.applyValue({ args0 -> args0 }))
            .syncDirection(
                syncDirection?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .syncGroupName(syncGroupName?.applyValue({ args0 -> args0 }))
            .syncMemberAzureDatabaseResourceId(
                syncMemberAzureDatabaseResourceId?.applyValue({ args0 ->
                    args0
                }),
            )
            .syncMemberName(syncMemberName?.applyValue({ args0 -> args0 }))
            .usePrivateLinkConnection(usePrivateLinkConnection?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SyncMemberArgs].
 */
@PulumiTagMarker
public class SyncMemberArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var databaseType: Output<Either<String, SyncMemberDbType>>? = null

    private var password: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sqlServerDatabaseId: Output<String>? = null

    private var syncAgentId: Output<String>? = null

    private var syncDirection: Output<Either<String, SyncDirection>>? = null

    private var syncGroupName: Output<String>? = null

    private var syncMemberAzureDatabaseResourceId: Output<String>? = null

    private var syncMemberName: Output<String>? = null

    private var usePrivateLinkConnection: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Database name of the member database in the sync member.
     */
    @JvmName("mqkomkpuorgmidaq")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Database type of the sync member.
     */
    @JvmName("mvrhpouaivmioery")
    public suspend fun databaseType(`value`: Output<Either<String, SyncMemberDbType>>) {
        this.databaseType = value
    }

    /**
     * @param value Password of the member database in the sync member.
     */
    @JvmName("vxsixxsmfkonkkiq")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("rqgarjgrvrdxxsoa")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Server name of the member database in the sync member
     */
    @JvmName("jgacuuiubqwdoeab")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value SQL Server database id of the sync member.
     */
    @JvmName("hcsauftslstvyuim")
    public suspend fun sqlServerDatabaseId(`value`: Output<String>) {
        this.sqlServerDatabaseId = value
    }

    /**
     * @param value ARM resource id of the sync agent in the sync member.
     */
    @JvmName("omvcnehnygyfbolo")
    public suspend fun syncAgentId(`value`: Output<String>) {
        this.syncAgentId = value
    }

    /**
     * @param value Sync direction of the sync member.
     */
    @JvmName("dcbccxvcyecvpsqg")
    public suspend fun syncDirection(`value`: Output<Either<String, SyncDirection>>) {
        this.syncDirection = value
    }

    /**
     * @param value The name of the sync group on which the sync member is hosted.
     */
    @JvmName("xkhgfoekvruqxkeo")
    public suspend fun syncGroupName(`value`: Output<String>) {
        this.syncGroupName = value
    }

    /**
     * @param value ARM resource id of the sync member logical database, for sync members in Azure.
     */
    @JvmName("utegovantyeemhda")
    public suspend fun syncMemberAzureDatabaseResourceId(`value`: Output<String>) {
        this.syncMemberAzureDatabaseResourceId = value
    }

    /**
     * @param value The name of the sync member.
     */
    @JvmName("tfpksrxjlbkusixr")
    public suspend fun syncMemberName(`value`: Output<String>) {
        this.syncMemberName = value
    }

    /**
     * @param value Whether to use private link connection.
     */
    @JvmName("sgdubyjghgcigacf")
    public suspend fun usePrivateLinkConnection(`value`: Output<Boolean>) {
        this.usePrivateLinkConnection = value
    }

    /**
     * @param value User name of the member database in the sync member.
     */
    @JvmName("hpwrjwaekqwafkuv")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Database name of the member database in the sync member.
     */
    @JvmName("yfgtqklspgkuymle")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Database type of the sync member.
     */
    @JvmName("gtphjbgkedxnbowo")
    public suspend fun databaseType(`value`: Either<String, SyncMemberDbType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Database type of the sync member.
     */
    @JvmName("tikxhvtbewgulfgc")
    public fun databaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncMemberDbType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Database type of the sync member.
     */
    @JvmName("yfpuityvlucmyhny")
    public fun databaseType(`value`: SyncMemberDbType) {
        val toBeMapped = Either.ofRight<String, SyncMemberDbType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.databaseType = mapped
    }

    /**
     * @param value Password of the member database in the sync member.
     */
    @JvmName("pluwoyavrggbardk")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xxwggbpckuovdyvj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Server name of the member database in the sync member
     */
    @JvmName("ikbgkorovvvgorax")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value SQL Server database id of the sync member.
     */
    @JvmName("ynwfhgbfbgthvjua")
    public suspend fun sqlServerDatabaseId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerDatabaseId = mapped
    }

    /**
     * @param value ARM resource id of the sync agent in the sync member.
     */
    @JvmName("kasaonrhxwbjytpj")
    public suspend fun syncAgentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncAgentId = mapped
    }

    /**
     * @param value Sync direction of the sync member.
     */
    @JvmName("drdnsdgessshtxtv")
    public suspend fun syncDirection(`value`: Either<String, SyncDirection>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncDirection = mapped
    }

    /**
     * @param value Sync direction of the sync member.
     */
    @JvmName("mdrgisyscjcftyve")
    public fun syncDirection(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SyncDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncDirection = mapped
    }

    /**
     * @param value Sync direction of the sync member.
     */
    @JvmName("ngdbbewidvgrmoao")
    public fun syncDirection(`value`: SyncDirection) {
        val toBeMapped = Either.ofRight<String, SyncDirection>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.syncDirection = mapped
    }

    /**
     * @param value The name of the sync group on which the sync member is hosted.
     */
    @JvmName("hoirejqwtligfqxi")
    public suspend fun syncGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncGroupName = mapped
    }

    /**
     * @param value ARM resource id of the sync member logical database, for sync members in Azure.
     */
    @JvmName("eunxtrahxijfxlyd")
    public suspend fun syncMemberAzureDatabaseResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMemberAzureDatabaseResourceId = mapped
    }

    /**
     * @param value The name of the sync member.
     */
    @JvmName("vncedrdkownpeyrh")
    public suspend fun syncMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.syncMemberName = mapped
    }

    /**
     * @param value Whether to use private link connection.
     */
    @JvmName("kodrasryyorytcin")
    public suspend fun usePrivateLinkConnection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usePrivateLinkConnection = mapped
    }

    /**
     * @param value User name of the member database in the sync member.
     */
    @JvmName("yyshcimnlpgvinqa")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): SyncMemberArgs = SyncMemberArgs(
        databaseName = databaseName,
        databaseType = databaseType,
        password = password,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sqlServerDatabaseId = sqlServerDatabaseId,
        syncAgentId = syncAgentId,
        syncDirection = syncDirection,
        syncGroupName = syncGroupName,
        syncMemberAzureDatabaseResourceId = syncMemberAzureDatabaseResourceId,
        syncMemberName = syncMemberName,
        usePrivateLinkConnection = usePrivateLinkConnection,
        userName = userName,
    )
}
