@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A virtual network rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a virtual network rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetworkRule = new AzureNative.Sql.VirtualNetworkRule("virtualNetworkRule", new()
 *     {
 *         IgnoreMissingVnetServiceEndpoint = false,
 *         ResourceGroupName = "Default",
 *         ServerName = "vnet-test-svr",
 *         VirtualNetworkRuleName = "vnet-firewall-rule",
 *         VirtualNetworkSubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewVirtualNetworkRule(ctx, "virtualNetworkRule", &sql.VirtualNetworkRuleArgs{
 * 			IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 			ResourceGroupName:                pulumi.String("Default"),
 * 			ServerName:                       pulumi.String("vnet-test-svr"),
 * 			VirtualNetworkRuleName:           pulumi.String("vnet-firewall-rule"),
 * 			VirtualNetworkSubnetId:           pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.VirtualNetworkRule;
 * import com.pulumi.azurenative.sql.VirtualNetworkRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetworkRule = new VirtualNetworkRule("virtualNetworkRule", VirtualNetworkRuleArgs.builder()
 *             .ignoreMissingVnetServiceEndpoint(false)
 *             .resourceGroupName("Default")
 *             .serverName("vnet-test-svr")
 *             .virtualNetworkRuleName("vnet-firewall-rule")
 *             .virtualNetworkSubnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Network/virtualNetworks/testvnet/subnets/testsubnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:VirtualNetworkRule vnet-firewall-rule /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/virtualNetworkRules/{virtualNetworkRuleName}
 * ```
 * @property ignoreMissingVnetServiceEndpoint Create firewall rule before the virtual network has vnet service endpoint enabled.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property virtualNetworkRuleName The name of the virtual network rule.
 * @property virtualNetworkSubnetId The ARM resource id of the virtual network subnet.
 */
public data class VirtualNetworkRuleArgs(
    public val ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val virtualNetworkRuleName: Output<String>? = null,
    public val virtualNetworkSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.sql.VirtualNetworkRuleArgs.builder()
            .ignoreMissingVnetServiceEndpoint(ignoreMissingVnetServiceEndpoint?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .virtualNetworkRuleName(virtualNetworkRuleName?.applyValue({ args0 -> args0 }))
            .virtualNetworkSubnetId(virtualNetworkSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var ignoreMissingVnetServiceEndpoint: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var virtualNetworkRuleName: Output<String>? = null

    private var virtualNetworkSubnetId: Output<String>? = null

    /**
     * @param value Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    @JvmName("gxquekkoutiqhoxi")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Output<Boolean>) {
        this.ignoreMissingVnetServiceEndpoint = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("seocucwfayfqsmab")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("pdvveetogwueuvac")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the virtual network rule.
     */
    @JvmName("veoeevujqsinrecl")
    public suspend fun virtualNetworkRuleName(`value`: Output<String>) {
        this.virtualNetworkRuleName = value
    }

    /**
     * @param value The ARM resource id of the virtual network subnet.
     */
    @JvmName("tfxojnuycoivomne")
    public suspend fun virtualNetworkSubnetId(`value`: Output<String>) {
        this.virtualNetworkSubnetId = value
    }

    /**
     * @param value Create firewall rule before the virtual network has vnet service endpoint enabled.
     */
    @JvmName("fnhtdtdfouepwyae")
    public suspend fun ignoreMissingVnetServiceEndpoint(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreMissingVnetServiceEndpoint = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("hwgpkrcpgdhibmit")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("efqjkurojxqhigdb")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the virtual network rule.
     */
    @JvmName("xxdctchnhokuctts")
    public suspend fun virtualNetworkRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkRuleName = mapped
    }

    /**
     * @param value The ARM resource id of the virtual network subnet.
     */
    @JvmName("ennbeohqyusnsqdu")
    public suspend fun virtualNetworkSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualNetworkSubnetId = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        ignoreMissingVnetServiceEndpoint = ignoreMissingVnetServiceEndpoint,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        virtualNetworkRuleName = virtualNetworkRuleName,
        virtualNetworkSubnetId = virtualNetworkSubnetId,
    )
}
