@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
 */
public enum class AutoExecuteStatus(
    public val javaValue: com.pulumi.azurenative.sql.enums.AutoExecuteStatus,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.AutoExecuteStatus> {
    Enabled(com.pulumi.azurenative.sql.enums.AutoExecuteStatus.Enabled),
    Disabled(com.pulumi.azurenative.sql.enums.AutoExecuteStatus.Disabled),
    Default(com.pulumi.azurenative.sql.enums.AutoExecuteStatus.Default),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.AutoExecuteStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.AutoExecuteStatus):
            AutoExecuteStatus = AutoExecuteStatus.values().first { it.javaValue == javaType }
    }
}
