@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The storage account type to be used to store backups for this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage)
 */
public enum class BackupStorageRedundancy(
    public val javaValue: com.pulumi.azurenative.sql.enums.BackupStorageRedundancy,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.BackupStorageRedundancy> {
    Geo(com.pulumi.azurenative.sql.enums.BackupStorageRedundancy.Geo),
    Local(com.pulumi.azurenative.sql.enums.BackupStorageRedundancy.Local),
    Zone(com.pulumi.azurenative.sql.enums.BackupStorageRedundancy.Zone),
    GeoZone(com.pulumi.azurenative.sql.enums.BackupStorageRedundancy.GeoZone),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.BackupStorageRedundancy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.BackupStorageRedundancy):
            BackupStorageRedundancy =
            BackupStorageRedundancy.values().first { it.javaValue == javaType }
    }
}
