@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit.
 */
public enum class DatabaseLicenseType(
    public val javaValue: com.pulumi.azurenative.sql.enums.DatabaseLicenseType,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.DatabaseLicenseType> {
    LicenseIncluded(com.pulumi.azurenative.sql.enums.DatabaseLicenseType.LicenseIncluded),
    BasePrice(com.pulumi.azurenative.sql.enums.DatabaseLicenseType.BasePrice),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.DatabaseLicenseType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.DatabaseLicenseType):
            DatabaseLicenseType = DatabaseLicenseType.values().first { it.javaValue == javaType }
    }
}
