@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.DatabaseIdentityArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.DatabaseIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Active Directory identity configuration for a resource.
 * @property type The identity type
 * @property userAssignedIdentities The resource ids of the user assigned identities to use
 */
public data class DatabaseIdentityArgs(
    public val type: Output<Either<String, DatabaseIdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.DatabaseIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.DatabaseIdentityArgs =
        com.pulumi.azurenative.sql.inputs.DatabaseIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DatabaseIdentityArgs].
 */
@PulumiTagMarker
public class DatabaseIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, DatabaseIdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type
     */
    @JvmName("tunihsdongqywyti")
    public suspend fun type(`value`: Output<Either<String, DatabaseIdentityType>>) {
        this.type = value
    }

    /**
     * @param value The resource ids of the user assigned identities to use
     */
    @JvmName("uwtixipjbyducwcp")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("oocbsexdlxxmatta")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The resource ids of the user assigned identities to use
     */
    @JvmName("xppceuqpkpyiyahr")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type
     */
    @JvmName("dgsgwukltqrjeuyc")
    public suspend fun type(`value`: Either<String, DatabaseIdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type
     */
    @JvmName("hqinoeuoxmcermtf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DatabaseIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type
     */
    @JvmName("lrqvxxgeoerowhve")
    public fun type(`value`: DatabaseIdentityType) {
        val toBeMapped = Either.ofRight<String, DatabaseIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The resource ids of the user assigned identities to use
     */
    @JvmName("naxbfqiglgbpgafi")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The resource ids of the user assigned identities to use
     */
    @JvmName("xpvtiyyindiyhpor")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): DatabaseIdentityArgs = DatabaseIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
