@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDatabaseAdvisorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property advisorName The name of the Database Advisor.
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetDatabaseAdvisorPlainArgs(
    public val advisorName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDatabaseAdvisorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetDatabaseAdvisorPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDatabaseAdvisorPlainArgs.builder()
            .advisorName(advisorName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseAdvisorPlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseAdvisorPlainArgsBuilder internal constructor() {
    private var advisorName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the Database Advisor.
     */
    @JvmName("scmdlfgfdqvfnnra")
    public suspend fun advisorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.advisorName = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("yiohdagaxjuslbun")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("pqsbjdujpewrtflu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("mkgtyrbgyaxahvbp")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetDatabaseAdvisorPlainArgs = GetDatabaseAdvisorPlainArgs(
        advisorName = advisorName ?: throw PulumiNullFieldException("advisorName"),
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
