@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDisasterRecoveryConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property disasterRecoveryConfigurationName The name of the disaster recovery configuration.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetDisasterRecoveryConfigurationPlainArgs(
    public val disasterRecoveryConfigurationName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDisasterRecoveryConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetDisasterRecoveryConfigurationPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDisasterRecoveryConfigurationPlainArgs.builder()
            .disasterRecoveryConfigurationName(disasterRecoveryConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDisasterRecoveryConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDisasterRecoveryConfigurationPlainArgsBuilder internal constructor() {
    private var disasterRecoveryConfigurationName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the disaster recovery configuration.
     */
    @JvmName("ggqdnstkukqrvpjc")
    public suspend fun disasterRecoveryConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.disasterRecoveryConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("enmtxhoyccieofvd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("tlybbhisamngnruk")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetDisasterRecoveryConfigurationPlainArgs =
        GetDisasterRecoveryConfigurationPlainArgs(
            disasterRecoveryConfigurationName = disasterRecoveryConfigurationName ?: throw
                PulumiNullFieldException("disasterRecoveryConfigurationName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        )
}
