@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDistributedAvailabilityGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property distributedAvailabilityGroupName The distributed availability group name.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetDistributedAvailabilityGroupPlainArgs(
    public val distributedAvailabilityGroupName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDistributedAvailabilityGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetDistributedAvailabilityGroupPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDistributedAvailabilityGroupPlainArgs.builder()
            .distributedAvailabilityGroupName(distributedAvailabilityGroupName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDistributedAvailabilityGroupPlainArgs].
 */
@PulumiTagMarker
public class GetDistributedAvailabilityGroupPlainArgsBuilder internal constructor() {
    private var distributedAvailabilityGroupName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The distributed availability group name.
     */
    @JvmName("xgcbqaapcvbuhatc")
    public suspend fun distributedAvailabilityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.distributedAvailabilityGroupName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("btrypfujtbppupoe")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vsajtvkjrsdfkavr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDistributedAvailabilityGroupPlainArgs =
        GetDistributedAvailabilityGroupPlainArgs(
            distributedAvailabilityGroupName = distributedAvailabilityGroupName ?: throw
                PulumiNullFieldException("distributedAvailabilityGroupName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
