@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetGeoBackupPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property geoBackupPolicyName The name of the Geo backup policy. This should always be 'Default'.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetGeoBackupPolicyPlainArgs(
    public val databaseName: String,
    public val geoBackupPolicyName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetGeoBackupPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetGeoBackupPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetGeoBackupPolicyPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .geoBackupPolicyName(geoBackupPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGeoBackupPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetGeoBackupPolicyPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var geoBackupPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("hfjausegqmwyvlqj")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Geo backup policy. This should always be 'Default'.
     */
    @JvmName("nyhvxmylbrcoyjwc")
    public suspend fun geoBackupPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.geoBackupPolicyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gnscpkrcwmkydnfw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("qiqteoavaibsgwgm")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetGeoBackupPolicyPlainArgs = GetGeoBackupPolicyPlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        geoBackupPolicyName = geoBackupPolicyName ?: throw PulumiNullFieldException("geoBackupPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
