@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetJobCredentialPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credentialName The name of the credential.
 * @property jobAgentName The name of the job agent.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetJobCredentialPlainArgs(
    public val credentialName: String,
    public val jobAgentName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetJobCredentialPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetJobCredentialPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetJobCredentialPlainArgs.builder()
            .credentialName(credentialName.let({ args0 -> args0 }))
            .jobAgentName(jobAgentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobCredentialPlainArgs].
 */
@PulumiTagMarker
public class GetJobCredentialPlainArgsBuilder internal constructor() {
    private var credentialName: String? = null

    private var jobAgentName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the credential.
     */
    @JvmName("akhxlfynmxbiskdi")
    public suspend fun credentialName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.credentialName = mapped
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("rniegndxqcioaowh")
    public suspend fun jobAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qqnsilahqcrwhxcd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xgymvvmfrqxdclim")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetJobCredentialPlainArgs = GetJobCredentialPlainArgs(
        credentialName = credentialName ?: throw PulumiNullFieldException("credentialName"),
        jobAgentName = jobAgentName ?: throw PulumiNullFieldException("jobAgentName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
