@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedDatabasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedDatabasePlainArgs(
    public val databaseName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedDatabasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetManagedDatabasePlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedDatabasePlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedDatabasePlainArgs].
 */
@PulumiTagMarker
public class GetManagedDatabasePlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("dtctvxiwvuyttlsy")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("lcmsdtexmpsslexf")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("uxcvlohxfoklqwwi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedDatabasePlainArgs = GetManagedDatabasePlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
