@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstanceAdministratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property administratorName
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedInstanceAdministratorPlainArgs(
    public val administratorName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstanceAdministratorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetManagedInstanceAdministratorPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceAdministratorPlainArgs.builder()
            .administratorName(administratorName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstanceAdministratorPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstanceAdministratorPlainArgsBuilder internal constructor() {
    private var administratorName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value
     */
    @JvmName("rsmigrdagnrstjen")
    public suspend fun administratorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.administratorName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("byglkqjlklygdifs")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dpmisdvpnjwfsqmu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedInstanceAdministratorPlainArgs =
        GetManagedInstanceAdministratorPlainArgs(
            administratorName = administratorName ?: throw PulumiNullFieldException("administratorName"),
            managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
