@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property vulnerabilityAssessmentName The name of the SQL Vulnerability Assessment.
 */
public data class GetSqlVulnerabilityAssessmentsSettingPlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
    public val vulnerabilityAssessmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetSqlVulnerabilityAssessmentsSettingPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlVulnerabilityAssessmentsSettingPlainArgs].
 */
@PulumiTagMarker
public class GetSqlVulnerabilityAssessmentsSettingPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("juaovwrjtwgkdmay")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("eogawlcvvlutulcr")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the SQL Vulnerability Assessment.
     */
    @JvmName("pfaqedjifaxocuin")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): GetSqlVulnerabilityAssessmentsSettingPlainArgs =
        GetSqlVulnerabilityAssessmentsSettingPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
        )
}
