@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetSyncAgentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server on which the sync agent is hosted.
 * @property syncAgentName The name of the sync agent.
 */
public data class GetSyncAgentPlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
    public val syncAgentName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetSyncAgentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetSyncAgentPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetSyncAgentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .syncAgentName(syncAgentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSyncAgentPlainArgs].
 */
@PulumiTagMarker
public class GetSyncAgentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var syncAgentName: String? = null

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("kpepnwvfwveejkgi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server on which the sync agent is hosted.
     */
    @JvmName("rdjfdjwhjmqfmepb")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the sync agent.
     */
    @JvmName("olfmjehyrkjkkfry")
    public suspend fun syncAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.syncAgentName = mapped
    }

    internal fun build(): GetSyncAgentPlainArgs = GetSyncAgentPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        syncAgentName = syncAgentName ?: throw PulumiNullFieldException("syncAgentName"),
    )
}
