@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadWriteEndpointArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ReadWriteEndpointFailoverPolicy
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Read-write endpoint of the failover group instance.
 * @property failoverPolicy Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
 * @property failoverWithDataLossGracePeriodMinutes Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
 */
public data class InstanceFailoverGroupReadWriteEndpointArgs(
    public val failoverPolicy: Output<Either<String, ReadWriteEndpointFailoverPolicy>>,
    public val failoverWithDataLossGracePeriodMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadWriteEndpointArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadWriteEndpointArgs =
        com.pulumi.azurenative.sql.inputs.InstanceFailoverGroupReadWriteEndpointArgs.builder()
            .failoverPolicy(
                failoverPolicy.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .failoverWithDataLossGracePeriodMinutes(
                failoverWithDataLossGracePeriodMinutes?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [InstanceFailoverGroupReadWriteEndpointArgs].
 */
@PulumiTagMarker
public class InstanceFailoverGroupReadWriteEndpointArgsBuilder internal constructor() {
    private var failoverPolicy: Output<Either<String, ReadWriteEndpointFailoverPolicy>>? = null

    private var failoverWithDataLossGracePeriodMinutes: Output<Int>? = null

    /**
     * @param value Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("aijijmgnkxjpseuq")
    public suspend
    fun failoverPolicy(`value`: Output<Either<String, ReadWriteEndpointFailoverPolicy>>) {
        this.failoverPolicy = value
    }

    /**
     * @param value Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("fdcowmfsifndcfwg")
    public suspend fun failoverWithDataLossGracePeriodMinutes(`value`: Output<Int>) {
        this.failoverWithDataLossGracePeriodMinutes = value
    }

    /**
     * @param value Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("tpsyrkevxraehlgd")
    public suspend fun failoverPolicy(`value`: Either<String, ReadWriteEndpointFailoverPolicy>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    /**
     * @param value Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("xsjynemrikohjypo")
    public fun failoverPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReadWriteEndpointFailoverPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    /**
     * @param value Failover policy of the read-write endpoint for the failover group. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("dieslujomhjucmut")
    public fun failoverPolicy(`value`: ReadWriteEndpointFailoverPolicy) {
        val toBeMapped = Either.ofRight<String, ReadWriteEndpointFailoverPolicy>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverPolicy = mapped
    }

    /**
     * @param value Grace period before failover with data loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required.
     */
    @JvmName("wanuajynsxjtogxg")
    public suspend fun failoverWithDataLossGracePeriodMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverWithDataLossGracePeriodMinutes = mapped
    }

    internal fun build(): InstanceFailoverGroupReadWriteEndpointArgs =
        InstanceFailoverGroupReadWriteEndpointArgs(
            failoverPolicy = failoverPolicy ?: throw PulumiNullFieldException("failoverPolicy"),
            failoverWithDataLossGracePeriodMinutes = failoverWithDataLossGracePeriodMinutes,
        )
}
