@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description The private link service connection description.
 * @property status The private link service connection status.
 */
public data class ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs(
    public val description: Output<String>,
    public val status: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs =
        com.pulumi.azurenative.sql.inputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs.builder()
            .description(description.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs].
 */
@PulumiTagMarker
public class ManagedInstancePrivateLinkServiceConnectionStatePropertyArgsBuilder internal
constructor() {
    private var description: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The private link service connection description.
     */
    @JvmName("smaiqvqotmcabhcr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("uaubwxcbbwixejjg")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The private link service connection description.
     */
    @JvmName("fttohorvabryivet")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The private link service connection status.
     */
    @JvmName("mqdlajmguenychtk")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs =
        ManagedInstancePrivateLinkServiceConnectionStatePropertyArgs(
            description = description ?: throw PulumiNullFieldException("description"),
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
