@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.PartnerInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Partner server information for the failover group.
 * @property id Resource identifier of the partner server.
 */
public data class PartnerInfoArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.PartnerInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.PartnerInfoArgs =
        com.pulumi.azurenative.sql.inputs.PartnerInfoArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PartnerInfoArgs].
 */
@PulumiTagMarker
public class PartnerInfoArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource identifier of the partner server.
     */
    @JvmName("gygupncjlghedbvd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource identifier of the partner server.
     */
    @JvmName("dytrgfradlfarpdl")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): PartnerInfoArgs = PartnerInfoArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
