@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ResourceIdentityArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Azure Active Directory identity configuration for a resource.
 * @property type The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
 * @property userAssignedIdentities The resource ids of the user assigned identities to use
 */
public data class ResourceIdentityArgs(
    public val type: Output<Either<String, IdentityType>>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.sql.inputs.ResourceIdentityArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, IdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
     */
    @JvmName("fpnluaprvyoembdh")
    public suspend fun type(`value`: Output<Either<String, IdentityType>>) {
        this.type = value
    }

    /**
     * @param value The resource ids of the user assigned identities to use
     */
    @JvmName("lyqaanpyaynqmekg")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("mhxmuoscbifctwdb")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The resource ids of the user assigned identities to use
     */
    @JvmName("tjufvxroynrgnfte")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
     */
    @JvmName("gaqkgraxnhifxfxb")
    public suspend fun type(`value`: Either<String, IdentityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
     */
    @JvmName("aqbuaoldgvhccaxj")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal for the resource.
     */
    @JvmName("rqpshqdnadtrqnbl")
    public fun type(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The resource ids of the user assigned identities to use
     */
    @JvmName("nlkbkevmdwpyntqp")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The resource ids of the user assigned identities to use
     */
    @JvmName("snbijhrqcnsgxsgh")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
