@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ServerInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Server info for the server trust group.
 * @property serverId Server Id.
 */
public data class ServerInfoArgs(
    public val serverId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ServerInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ServerInfoArgs =
        com.pulumi.azurenative.sql.inputs.ServerInfoArgs.builder()
            .serverId(serverId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerInfoArgs].
 */
@PulumiTagMarker
public class ServerInfoArgsBuilder internal constructor() {
    private var serverId: Output<String>? = null

    /**
     * @param value Server Id.
     */
    @JvmName("wancmecydiqxbfdj")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value Server Id.
     */
    @JvmName("wfpdtlvuvturdqsc")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    internal fun build(): ServerInfoArgs = ServerInfoArgs(
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
    )
}
