@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A database resource.
 * @property autoPauseDelay Time in minutes after which database is automatically paused. A value of -1 means that automatic pause is disabled
 * @property catalogCollation Collation of the metadata catalog.
 * @property collation The collation of the database.
 * @property creationDate The creation date of the database (ISO8601 format).
 * @property currentBackupStorageRedundancy The storage account type used to store backups for this database.
 * @property currentServiceObjectiveName The current service level objective name of the database.
 * @property currentSku The name and tier of the SKU.
 * @property databaseId The ID of the database.
 * @property defaultSecondaryLocation The default secondary region for this database.
 * @property earliestRestoreDate This records the earliest start date and time that restore is available for this database (ISO8601 format).
 * @property elasticPoolId The resource identifier of the elastic pool containing this database.
 * @property failoverGroupId Failover Group resource identifier that this database belongs to.
 * @property federatedClientId The Client id used for cross tenant per database CMK scenario
 * @property highAvailabilityReplicaCount The number of secondary replicas associated with the database that are used to provide high availability. Not applicable to a Hyperscale database within an elastic pool.
 * @property id Resource ID.
 * @property identity The Azure Active Directory identity of the database.
 * @property isInfraEncryptionEnabled Infra encryption is enabled for this database.
 * @property isLedgerOn Whether or not this database is a ledger database, which means all tables in the database are ledger tables. Note: the value of this property cannot be changed after the database has been created.
 * @property kind Kind of database. This is metadata used for the Azure portal experience.
 * @property licenseType The license type to apply for this database. `LicenseIncluded` if you need a license, or `BasePrice` if you have a license and are eligible for the Azure Hybrid Benefit.
 * @property location Resource location.
 * @property maintenanceConfigurationId Maintenance configuration id assigned to the database. This configuration defines the period when the maintenance updates will occur.
 * @property managedBy Resource that manages the database.
 * @property maxLogSizeBytes The max log size for this database.
 * @property maxSizeBytes The max size of the database expressed in bytes.
 * @property minCapacity Minimal capacity that database will always have allocated, if not paused
 * @property name Resource name.
 * @property pausedDate The date when database was paused by user configuration or action(ISO8601 format). Null if the database is ready.
 * @property readScale The state of read-only routing. If enabled, connections that have application intent set to readonly in their connection string may be routed to a readonly secondary replica in the same region. Not applicable to a Hyperscale database within an elastic pool.
 * @property requestedBackupStorageRedundancy The storage account type to be used to store backups for this database.
 * @property requestedServiceObjectiveName The requested service level objective name of the database.
 * @property resumedDate The date when database was resumed by user action or database login (ISO8601 format). Null if the database is paused.
 * @property secondaryType The secondary type of the database if it is a secondary.  Valid values are Geo and Named.
 * @property sku The database SKU.
 * The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU name, tier/edition, family, and capacity) that are available to your subscription in an Azure region, use the `Capabilities_ListByLocation` REST API or one of the following commands:
 * ```azurecli
 * az sql db list-editions -l <location> -o table
 * ````
 * ```powershell
 * Get-AzSqlServerServiceObjective -Location <location>
 * ````
 * @property status The status of the database.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zoneRedundant Whether or not this database is zone redundant, which means the replicas of this database will be spread across multiple availability zones.
 */
public data class GetDatabaseResult(
    public val autoPauseDelay: Int? = null,
    public val catalogCollation: String? = null,
    public val collation: String? = null,
    public val creationDate: String,
    public val currentBackupStorageRedundancy: String,
    public val currentServiceObjectiveName: String,
    public val currentSku: SkuResponse,
    public val databaseId: String,
    public val defaultSecondaryLocation: String,
    public val earliestRestoreDate: String,
    public val elasticPoolId: String? = null,
    public val failoverGroupId: String,
    public val federatedClientId: String? = null,
    public val highAvailabilityReplicaCount: Int? = null,
    public val id: String,
    public val identity: DatabaseIdentityResponse? = null,
    public val isInfraEncryptionEnabled: Boolean,
    public val isLedgerOn: Boolean? = null,
    public val kind: String,
    public val licenseType: String? = null,
    public val location: String,
    public val maintenanceConfigurationId: String? = null,
    public val managedBy: String,
    public val maxLogSizeBytes: Double,
    public val maxSizeBytes: Double? = null,
    public val minCapacity: Double? = null,
    public val name: String,
    public val pausedDate: String,
    public val readScale: String? = null,
    public val requestedBackupStorageRedundancy: String? = null,
    public val requestedServiceObjectiveName: String,
    public val resumedDate: String,
    public val secondaryType: String? = null,
    public val sku: SkuResponse? = null,
    public val status: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneRedundant: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetDatabaseResult):
            GetDatabaseResult = GetDatabaseResult(
            autoPauseDelay = javaType.autoPauseDelay().map({ args0 -> args0 }).orElse(null),
            catalogCollation = javaType.catalogCollation().map({ args0 -> args0 }).orElse(null),
            collation = javaType.collation().map({ args0 -> args0 }).orElse(null),
            creationDate = javaType.creationDate(),
            currentBackupStorageRedundancy = javaType.currentBackupStorageRedundancy(),
            currentServiceObjectiveName = javaType.currentServiceObjectiveName(),
            currentSku = javaType.currentSku().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            databaseId = javaType.databaseId(),
            defaultSecondaryLocation = javaType.defaultSecondaryLocation(),
            earliestRestoreDate = javaType.earliestRestoreDate(),
            elasticPoolId = javaType.elasticPoolId().map({ args0 -> args0 }).orElse(null),
            failoverGroupId = javaType.failoverGroupId(),
            federatedClientId = javaType.federatedClientId().map({ args0 -> args0 }).orElse(null),
            highAvailabilityReplicaCount = javaType.highAvailabilityReplicaCount().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.DatabaseIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            isInfraEncryptionEnabled = javaType.isInfraEncryptionEnabled(),
            isLedgerOn = javaType.isLedgerOn().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            licenseType = javaType.licenseType().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            maintenanceConfigurationId = javaType.maintenanceConfigurationId().map({ args0 ->
                args0
            }).orElse(null),
            managedBy = javaType.managedBy(),
            maxLogSizeBytes = javaType.maxLogSizeBytes(),
            maxSizeBytes = javaType.maxSizeBytes().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            pausedDate = javaType.pausedDate(),
            readScale = javaType.readScale().map({ args0 -> args0 }).orElse(null),
            requestedBackupStorageRedundancy = javaType.requestedBackupStorageRedundancy().map({ args0 ->
                args0
            }).orElse(null),
            requestedServiceObjectiveName = javaType.requestedServiceObjectiveName(),
            resumedDate = javaType.resumedDate(),
            secondaryType = javaType.secondaryType().map({ args0 -> args0 }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneRedundant = javaType.zoneRedundant().map({ args0 -> args0 }).orElse(null),
        )
    }
}
