@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A managed instance key.
 * @property autoRotationEnabled Key auto rotation opt-in flag. Either true or false.
 * @property creationDate The key creation date.
 * @property id Resource ID.
 * @property kind Kind of encryption protector. This is metadata used for the Azure portal experience.
 * @property name Resource name.
 * @property thumbprint Thumbprint of the key.
 * @property type Resource type.
 */
public data class GetManagedInstanceKeyResult(
    public val autoRotationEnabled: Boolean,
    public val creationDate: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstanceKeyResult):
            GetManagedInstanceKeyResult = GetManagedInstanceKeyResult(
            autoRotationEnabled = javaType.autoRotationEnabled(),
            creationDate = javaType.creationDate(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
