@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection
 * @property id Resource ID.
 * @property name Resource name.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property provisioningState State of the Private Endpoint Connection.
 * @property type Resource type.
 */
public data class GetManagedInstancePrivateEndpointConnectionResult(
    public val id: String,
    public val name: String,
    public val privateEndpoint: ManagedInstancePrivateEndpointPropertyResponse? = null,
    public val privateLinkServiceConnectionState:
    ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstancePrivateEndpointConnectionResult):
            GetManagedInstancePrivateEndpointConnectionResult =
            GetManagedInstancePrivateEndpointConnectionResult(
                id = javaType.id(),
                name = javaType.name(),
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateEndpointPropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
                type = javaType.type(),
            )
    }
}
