@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A replication link.
 * @property id Resource ID.
 * @property isTerminationAllowed Whether the user is currently allowed to terminate the link.
 * @property linkType Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
 * @property name Resource name.
 * @property partnerDatabase Resource partner database.
 * @property partnerDatabaseId Resource partner database Id.
 * @property partnerLocation Resource partner location.
 * @property partnerRole Partner replication role.
 * @property partnerServer Resource partner server.
 * @property percentComplete Seeding completion percentage for the link.
 * @property replicationMode Replication mode.
 * @property replicationState Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED).
 * @property role Local replication role.
 * @property startTime Time at which the link was created.
 * @property type Resource type.
 */
public data class GetReplicationLinkResult(
    public val id: String,
    public val isTerminationAllowed: Boolean,
    public val linkType: String? = null,
    public val name: String,
    public val partnerDatabase: String,
    public val partnerDatabaseId: String,
    public val partnerLocation: String,
    public val partnerRole: String,
    public val partnerServer: String,
    public val percentComplete: Int,
    public val replicationMode: String,
    public val replicationState: String,
    public val role: String,
    public val startTime: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetReplicationLinkResult):
            GetReplicationLinkResult = GetReplicationLinkResult(
            id = javaType.id(),
            isTerminationAllowed = javaType.isTerminationAllowed(),
            linkType = javaType.linkType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            partnerDatabase = javaType.partnerDatabase(),
            partnerDatabaseId = javaType.partnerDatabaseId(),
            partnerLocation = javaType.partnerLocation(),
            partnerRole = javaType.partnerRole(),
            partnerServer = javaType.partnerServer(),
            percentComplete = javaType.percentComplete(),
            replicationMode = javaType.replicationMode(),
            replicationState = javaType.replicationState(),
            role = javaType.role(),
            startTime = javaType.startTime(),
            type = javaType.type(),
        )
    }
}
