@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Azure Active Directory administrator.
 * @property administratorType Type of the sever administrator.
 * @property azureADOnlyAuthentication Azure Active Directory only Authentication enabled.
 * @property id Resource ID.
 * @property login Login name of the server administrator.
 * @property name Resource name.
 * @property sid SID (object ID) of the server administrator.
 * @property tenantId Tenant ID of the administrator.
 * @property type Resource type.
 */
public data class GetServerAzureADAdministratorResult(
    public val administratorType: String,
    public val azureADOnlyAuthentication: Boolean,
    public val id: String,
    public val login: String,
    public val name: String,
    public val sid: String,
    public val tenantId: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerAzureADAdministratorResult):
            GetServerAzureADAdministratorResult = GetServerAzureADAdministratorResult(
            administratorType = javaType.administratorType(),
            azureADOnlyAuthentication = javaType.azureADOnlyAuthentication(),
            id = javaType.id(),
            login = javaType.login(),
            name = javaType.name(),
            sid = javaType.sid(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
