@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A job target, for example a specific database or a container of databases that is evaluated during job execution.
 * @property databaseName The target database name.
 * @property elasticPoolName The target elastic pool name.
 * @property membershipType Whether the target is included or excluded from the group.
 * @property refreshCredential The resource ID of the credential that is used during job execution to connect to the target and determine the list of databases inside the target.
 * @property serverName The target server name.
 * @property shardMapName The target shard map.
 * @property type The target type.
 */
public data class JobTargetResponse(
    public val databaseName: String? = null,
    public val elasticPoolName: String? = null,
    public val membershipType: String? = null,
    public val refreshCredential: String? = null,
    public val serverName: String? = null,
    public val shardMapName: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.JobTargetResponse):
            JobTargetResponse = JobTargetResponse(
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            elasticPoolName = javaType.elasticPoolName().map({ args0 -> args0 }).orElse(null),
            membershipType = javaType.membershipType().map({ args0 -> args0 }).orElse(null),
            refreshCredential = javaType.refreshCredential().map({ args0 -> args0 }).orElse(null),
            serverName = javaType.serverName().map({ args0 -> args0 }).orElse(null),
            shardMapName = javaType.shardMapName().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
