@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of table in sync group schema.
 * @property columns List of columns in sync group schema.
 * @property quotedName Quoted name of sync group schema table.
 */
public data class SyncGroupSchemaTableResponse(
    public val columns: List<SyncGroupSchemaTableColumnResponse>? = null,
    public val quotedName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.SyncGroupSchemaTableResponse):
            SyncGroupSchemaTableResponse = SyncGroupSchemaTableResponse(
            columns = javaType.columns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SyncGroupSchemaTableColumnResponse.Companion.toKotlin(args0)
                })
            }),
            quotedName = javaType.quotedName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
