@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AssessmentSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoBackupSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoPatchingSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.KeyVaultCredentialSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ResourceIdentityResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ServerConfigurationsManagementSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.StorageConfigurationSettingsResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainCredentialsResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AssessmentSettingsResponse.Companion.toKotlin as assessmentSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoBackupSettingsResponse.Companion.toKotlin as autoBackupSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.AutoPatchingSettingsResponse.Companion.toKotlin as autoPatchingSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.KeyVaultCredentialSettingsResponse.Companion.toKotlin as keyVaultCredentialSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin as resourceIdentityResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.ServerConfigurationsManagementSettingsResponse.Companion.toKotlin as serverConfigurationsManagementSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.StorageConfigurationSettingsResponse.Companion.toKotlin as storageConfigurationSettingsResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainCredentialsResponse.Companion.toKotlin as wsfcDomainCredentialsResponseToKotlin

/**
 * Builder for [SqlVirtualMachine].
 */
@PulumiTagMarker
public class SqlVirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlVirtualMachineArgs = SqlVirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlVirtualMachineArgsBuilder.() -> Unit) {
        val builder = SqlVirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlVirtualMachine {
        val builtJavaResource =
            com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlVirtualMachine(builtJavaResource)
    }
}

/**
 * A SQL virtual machine.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a SQL virtual machine and joins it to a SQL virtual machine group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2",
 *         WsfcDomainCredentials = new AzureNative.SqlVirtualMachine.Inputs.WsfcDomainCredentialsArgs
 *         {
 *             ClusterBootstrapAccountPassword = "<Password>",
 *             ClusterOperatorAccountPassword = "<Password>",
 *             SqlServiceAccountPassword = "<Password>",
 *         },
 *         WsfcStaticIp = "10.0.0.7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:                         pulumi.String("northeurope"),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup"),
 * 			SqlVirtualMachineName:            pulumi.String("testvm"),
 * 			VirtualMachineResourceId:         pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2"),
 * 			WsfcDomainCredentials: &sqlvirtualmachine.WsfcDomainCredentialsArgs{
 * 				ClusterBootstrapAccountPassword: pulumi.String("<Password>"),
 * 				ClusterOperatorAccountPassword:  pulumi.String("<Password>"),
 * 				SqlServiceAccountPassword:       pulumi.String("<Password>"),
 * 			},
 * 			WsfcStaticIp: pulumi.String("10.0.0.7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2")
 *             .wsfcDomainCredentials(Map.ofEntries(
 *                 Map.entry("clusterBootstrapAccountPassword", "<Password>"),
 *                 Map.entry("clusterOperatorAccountPassword", "<Password>"),
 *                 Map.entry("sqlServiceAccountPassword", "<Password>")
 *             ))
 *             .wsfcStaticIp("10.0.0.7")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Automated Back up Settings with Weekly and Days of the week to run the back up.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         AutoBackupSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoBackupSettingsArgs
 *         {
 *             BackupScheduleType = "Manual",
 *             BackupSystemDbs = true,
 *             DaysOfWeek = new[]
 *             {
 *                 "Monday",
 *                 "Friday",
 *             },
 *             Enable = true,
 *             EnableEncryption = true,
 *             FullBackupFrequency = "Weekly",
 *             FullBackupStartTime = 6,
 *             FullBackupWindowHours = 11,
 *             LogBackupFrequency = 10,
 *             Password = "<Password>",
 *             RetentionPeriod = 17,
 *             StorageAccessKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://teststorage.blob.core.windows.net/",
 *             StorageContainerName = "testcontainer",
 *         },
 *         AutoPatchingSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoPatchingSettingsArgs
 *         {
 *             DayOfWeek = AzureNative.SqlVirtualMachine.DayOfWeek.Sunday,
 *             Enable = true,
 *             MaintenanceWindowDuration = 60,
 *             MaintenanceWindowStartingHour = 2,
 *         },
 *         KeyVaultCredentialSettings = new AzureNative.SqlVirtualMachine.Inputs.KeyVaultCredentialSettingsArgs
 *         {
 *             Enable = false,
 *         },
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         ServerConfigurationsManagementSettings = new AzureNative.SqlVirtualMachine.Inputs.ServerConfigurationsManagementSettingsArgs
 *         {
 *             AdditionalFeaturesServerConfigurations = new AzureNative.SqlVirtualMachine.Inputs.AdditionalFeaturesServerConfigurationsArgs
 *             {
 *                 IsRServicesEnabled = false,
 *             },
 *             SqlConnectivityUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlConnectivityUpdateSettingsArgs
 *             {
 *                 ConnectivityType = "PRIVATE",
 *                 Port = 1433,
 *                 SqlAuthUpdatePassword = "<password>",
 *                 SqlAuthUpdateUserName = "sqllogin",
 *             },
 *             SqlStorageUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlStorageUpdateSettingsArgs
 *             {
 *                 DiskConfigurationType = "NEW",
 *                 DiskCount = 1,
 *                 StartingDeviceId = 2,
 *             },
 *             SqlWorkloadTypeUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlWorkloadTypeUpdateSettingsArgs
 *             {
 *                 SqlWorkloadType = "OLTP",
 *             },
 *         },
 *         SqlImageSku = "Enterprise",
 *         SqlManagement = "Full",
 *         SqlServerLicenseType = "PAYG",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			AutoBackupSettings: &sqlvirtualmachine.AutoBackupSettingsArgs{
 * 				BackupScheduleType: pulumi.String("Manual"),
 * 				BackupSystemDbs:    pulumi.Bool(true),
 * 				DaysOfWeek: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 					pulumi.String("Friday"),
 * 				},
 * 				Enable:                pulumi.Bool(true),
 * 				EnableEncryption:      pulumi.Bool(true),
 * 				FullBackupFrequency:   pulumi.String("Weekly"),
 * 				FullBackupStartTime:   pulumi.Int(6),
 * 				FullBackupWindowHours: pulumi.Int(11),
 * 				LogBackupFrequency:    pulumi.Int(10),
 * 				Password:              pulumi.String("<Password>"),
 * 				RetentionPeriod:       pulumi.Int(17),
 * 				StorageAccessKey:      pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:     pulumi.String("https://teststorage.blob.core.windows.net/"),
 * 				StorageContainerName:  pulumi.String("testcontainer"),
 * 			},
 * 			AutoPatchingSettings: &sqlvirtualmachine.AutoPatchingSettingsArgs{
 * 				DayOfWeek:                     sqlvirtualmachine.DayOfWeekSunday,
 * 				Enable:                        pulumi.Bool(true),
 * 				MaintenanceWindowDuration:     pulumi.Int(60),
 * 				MaintenanceWindowStartingHour: pulumi.Int(2),
 * 			},
 * 			KeyVaultCredentialSettings: &sqlvirtualmachine.KeyVaultCredentialSettingsArgs{
 * 				Enable: pulumi.Bool(false),
 * 			},
 * 			Location:          pulumi.String("northeurope"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerConfigurationsManagementSettings: sqlvirtualmachine.ServerConfigurationsManagementSettingsResponse{
 * 				AdditionalFeaturesServerConfigurations: &sqlvirtualmachine.AdditionalFeaturesServerConfigurationsArgs{
 * 					IsRServicesEnabled: pulumi.Bool(false),
 * 				},
 * 				SqlConnectivityUpdateSettings: &sqlvirtualmachine.SqlConnectivityUpdateSettingsArgs{
 * 					ConnectivityType:      pulumi.String("PRIVATE"),
 * 					Port:                  pulumi.Int(1433),
 * 					SqlAuthUpdatePassword: pulumi.String("<password>"),
 * 					SqlAuthUpdateUserName: pulumi.String("sqllogin"),
 * 				},
 * 				SqlStorageUpdateSettings: &sqlvirtualmachine.SqlStorageUpdateSettingsArgs{
 * 					DiskConfigurationType: pulumi.String("NEW"),
 * 					DiskCount:             pulumi.Int(1),
 * 					StartingDeviceId:      pulumi.Int(2),
 * 				},
 * 				SqlWorkloadTypeUpdateSettings: &sqlvirtualmachine.SqlWorkloadTypeUpdateSettingsArgs{
 * 					SqlWorkloadType: pulumi.String("OLTP"),
 * 				},
 * 			},
 * 			SqlImageSku:              pulumi.String("Enterprise"),
 * 			SqlManagement:            pulumi.String("Full"),
 * 			SqlServerLicenseType:     pulumi.String("PAYG"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .autoBackupSettings(Map.ofEntries(
 *                 Map.entry("backupScheduleType", "Manual"),
 *                 Map.entry("backupSystemDbs", true),
 *                 Map.entry("daysOfWeek",
 *                     "Monday",
 *                     "Friday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("enableEncryption", true),
 *                 Map.entry("fullBackupFrequency", "Weekly"),
 *                 Map.entry("fullBackupStartTime", 6),
 *                 Map.entry("fullBackupWindowHours", 11),
 *                 Map.entry("logBackupFrequency", 10),
 *                 Map.entry("password", "<Password>"),
 *                 Map.entry("retentionPeriod", 17),
 *                 Map.entry("storageAccessKey", "<primary storage access key>"),
 *                 Map.entry("storageAccountUrl", "https://teststorage.blob.core.windows.net/"),
 *                 Map.entry("storageContainerName", "testcontainer")
 *             ))
 *             .autoPatchingSettings(Map.ofEntries(
 *                 Map.entry("dayOfWeek", "Sunday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("maintenanceWindowDuration", 60),
 *                 Map.entry("maintenanceWindowStartingHour", 2)
 *             ))
 *             .keyVaultCredentialSettings(Map.of("enable", false))
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .serverConfigurationsManagementSettings(Map.ofEntries(
 *                 Map.entry("additionalFeaturesServerConfigurations", Map.of("isRServicesEnabled", false)),
 *                 Map.entry("sqlConnectivityUpdateSettings", Map.ofEntries(
 *                     Map.entry("connectivityType", "PRIVATE"),
 *                     Map.entry("port", 1433),
 *                     Map.entry("sqlAuthUpdatePassword", "<password>"),
 *                     Map.entry("sqlAuthUpdateUserName", "sqllogin")
 *                 )),
 *                 Map.entry("sqlStorageUpdateSettings", Map.ofEntries(
 *                     Map.entry("diskConfigurationType", "NEW"),
 *                     Map.entry("diskCount", 1),
 *                     Map.entry("startingDeviceId", 2)
 *                 )),
 *                 Map.entry("sqlWorkloadTypeUpdateSettings", Map.of("sqlWorkloadType", "OLTP"))
 *             ))
 *             .sqlImageSku("Enterprise")
 *             .sqlManagement("Full")
 *             .sqlServerLicenseType("PAYG")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Storage Configuration Settings to EXTEND Data, Log or TempDB storage pool.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         StorageConfigurationSettings = new AzureNative.SqlVirtualMachine.Inputs.StorageConfigurationSettingsArgs
 *         {
 *             DiskConfigurationType = "EXTEND",
 *             SqlDataSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 Luns = new[]
 *                 {
 *                     2,
 *                 },
 *             },
 *         },
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:              pulumi.String("northeurope"),
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlVirtualMachineName: pulumi.String("testvm"),
 * 			StorageConfigurationSettings: sqlvirtualmachine.StorageConfigurationSettingsResponse{
 * 				DiskConfigurationType: pulumi.String("EXTEND"),
 * 				SqlDataSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .storageConfigurationSettings(Map.ofEntries(
 *                 Map.entry("diskConfigurationType", "EXTEND"),
 *                 Map.entry("sqlDataSettings", Map.of("luns", 2))
 *             ))
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Storage Configuration Settings to NEW Data, Log and TempDB storage pool.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         StorageConfigurationSettings = new AzureNative.SqlVirtualMachine.Inputs.StorageConfigurationSettingsArgs
 *         {
 *             DiskConfigurationType = "NEW",
 *             SqlDataSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 DefaultFilePath = "F:\\folderpath\\",
 *                 Luns = new[]
 *                 {
 *                     0,
 *                 },
 *             },
 *             SqlLogSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 DefaultFilePath = "G:\\folderpath\\",
 *                 Luns = new[]
 *                 {
 *                     1,
 *                 },
 *             },
 *             SqlSystemDbOnDataDisk = true,
 *             SqlTempDbSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLTempDbSettingsArgs
 *             {
 *                 DataFileCount = 8,
 *                 DataFileSize = 256,
 *                 DataGrowth = 512,
 *                 DefaultFilePath = "D:\\TEMP",
 *                 LogFileSize = 256,
 *                 LogGrowth = 512,
 *             },
 *             StorageWorkloadType = "OLTP",
 *         },
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:              pulumi.String("northeurope"),
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlVirtualMachineName: pulumi.String("testvm"),
 * 			StorageConfigurationSettings: sqlvirtualmachine.StorageConfigurationSettingsResponse{
 * 				DiskConfigurationType: pulumi.String("NEW"),
 * 				SqlDataSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					DefaultFilePath: pulumi.String("F:\\folderpath\\"),
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(0),
 * 					},
 * 				},
 * 				SqlLogSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					DefaultFilePath: pulumi.String("G:\\folderpath\\"),
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 					},
 * 				},
 * 				SqlSystemDbOnDataDisk: pulumi.Bool(true),
 * 				SqlTempDbSettings: &sqlvirtualmachine.SQLTempDbSettingsArgs{
 * 					DataFileCount:   pulumi.Int(8),
 * 					DataFileSize:    pulumi.Int(256),
 * 					DataGrowth:      pulumi.Int(512),
 * 					DefaultFilePath: pulumi.String("D:\\TEMP"),
 * 					LogFileSize:     pulumi.Int(256),
 * 					LogGrowth:       pulumi.Int(512),
 * 				},
 * 				StorageWorkloadType: pulumi.String("OLTP"),
 * 			},
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .storageConfigurationSettings(Map.ofEntries(
 *                 Map.entry("diskConfigurationType", "NEW"),
 *                 Map.entry("sqlDataSettings", Map.ofEntries(
 *                     Map.entry("defaultFilePath", "F:\\folderpath\\"),
 *                     Map.entry("luns", 0)
 *                 )),
 *                 Map.entry("sqlLogSettings", Map.ofEntries(
 *                     Map.entry("defaultFilePath", "G:\\folderpath\\"),
 *                     Map.entry("luns", 1)
 *                 )),
 *                 Map.entry("sqlSystemDbOnDataDisk", true),
 *                 Map.entry("sqlTempDbSettings", Map.ofEntries(
 *                     Map.entry("dataFileCount", 8),
 *                     Map.entry("dataFileSize", 256),
 *                     Map.entry("dataGrowth", 512),
 *                     Map.entry("defaultFilePath", "D:\\TEMP"),
 *                     Map.entry("logFileSize", 256),
 *                     Map.entry("logGrowth", 512)
 *                 )),
 *                 Map.entry("storageWorkloadType", "OLTP")
 *             ))
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine with max parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         AssessmentSettings = new AzureNative.SqlVirtualMachine.Inputs.AssessmentSettingsArgs
 *         {
 *             Enable = true,
 *             RunImmediately = true,
 *             Schedule = new AzureNative.SqlVirtualMachine.Inputs.ScheduleArgs
 *             {
 *                 DayOfWeek = AzureNative.SqlVirtualMachine.AssessmentDayOfWeek.Sunday,
 *                 Enable = true,
 *                 StartTime = "23:17",
 *                 WeeklyInterval = 1,
 *             },
 *         },
 *         AutoBackupSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoBackupSettingsArgs
 *         {
 *             BackupScheduleType = "Manual",
 *             BackupSystemDbs = true,
 *             Enable = true,
 *             EnableEncryption = true,
 *             FullBackupFrequency = "Daily",
 *             FullBackupStartTime = 6,
 *             FullBackupWindowHours = 11,
 *             LogBackupFrequency = 10,
 *             Password = "<Password>",
 *             RetentionPeriod = 17,
 *             StorageAccessKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://teststorage.blob.core.windows.net/",
 *             StorageContainerName = "testcontainer",
 *         },
 *         AutoPatchingSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoPatchingSettingsArgs
 *         {
 *             DayOfWeek = AzureNative.SqlVirtualMachine.DayOfWeek.Sunday,
 *             Enable = true,
 *             MaintenanceWindowDuration = 60,
 *             MaintenanceWindowStartingHour = 2,
 *         },
 *         KeyVaultCredentialSettings = new AzureNative.SqlVirtualMachine.Inputs.KeyVaultCredentialSettingsArgs
 *         {
 *             Enable = false,
 *         },
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         ServerConfigurationsManagementSettings = new AzureNative.SqlVirtualMachine.Inputs.ServerConfigurationsManagementSettingsArgs
 *         {
 *             AdditionalFeaturesServerConfigurations = new AzureNative.SqlVirtualMachine.Inputs.AdditionalFeaturesServerConfigurationsArgs
 *             {
 *                 IsRServicesEnabled = false,
 *             },
 *             SqlConnectivityUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlConnectivityUpdateSettingsArgs
 *             {
 *                 ConnectivityType = "PRIVATE",
 *                 Port = 1433,
 *                 SqlAuthUpdatePassword = "<password>",
 *                 SqlAuthUpdateUserName = "sqllogin",
 *             },
 *             SqlInstanceSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLInstanceSettingsArgs
 *             {
 *                 Collation = "SQL_Latin1_General_CP1_CI_AS",
 *                 IsIfiEnabled = true,
 *                 IsLpimEnabled = true,
 *                 IsOptimizeForAdHocWorkloadsEnabled = true,
 *                 MaxDop = 8,
 *                 MaxServerMemoryMB = 128,
 *                 MinServerMemoryMB = 0,
 *             },
 *             SqlStorageUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlStorageUpdateSettingsArgs
 *             {
 *                 DiskConfigurationType = "NEW",
 *                 DiskCount = 1,
 *                 StartingDeviceId = 2,
 *             },
 *             SqlWorkloadTypeUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlWorkloadTypeUpdateSettingsArgs
 *             {
 *                 SqlWorkloadType = "OLTP",
 *             },
 *         },
 *         SqlImageSku = "Enterprise",
 *         SqlManagement = "Full",
 *         SqlServerLicenseType = "PAYG",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			AssessmentSettings: sqlvirtualmachine.AssessmentSettingsResponse{
 * 				Enable:         pulumi.Bool(true),
 * 				RunImmediately: pulumi.Bool(true),
 * 				Schedule: &sqlvirtualmachine.ScheduleArgs{
 * 					DayOfWeek:      sqlvirtualmachine.AssessmentDayOfWeekSunday,
 * 					Enable:         pulumi.Bool(true),
 * 					StartTime:      pulumi.String("23:17"),
 * 					WeeklyInterval: pulumi.Int(1),
 * 				},
 * 			},
 * 			AutoBackupSettings: &sqlvirtualmachine.AutoBackupSettingsArgs{
 * 				BackupScheduleType:    pulumi.String("Manual"),
 * 				BackupSystemDbs:       pulumi.Bool(true),
 * 				Enable:                pulumi.Bool(true),
 * 				EnableEncryption:      pulumi.Bool(true),
 * 				FullBackupFrequency:   pulumi.String("Daily"),
 * 				FullBackupStartTime:   pulumi.Int(6),
 * 				FullBackupWindowHours: pulumi.Int(11),
 * 				LogBackupFrequency:    pulumi.Int(10),
 * 				Password:              pulumi.String("<Password>"),
 * 				RetentionPeriod:       pulumi.Int(17),
 * 				StorageAccessKey:      pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:     pulumi.String("https://teststorage.blob.core.windows.net/"),
 * 				StorageContainerName:  pulumi.String("testcontainer"),
 * 			},
 * 			AutoPatchingSettings: &sqlvirtualmachine.AutoPatchingSettingsArgs{
 * 				DayOfWeek:                     sqlvirtualmachine.DayOfWeekSunday,
 * 				Enable:                        pulumi.Bool(true),
 * 				MaintenanceWindowDuration:     pulumi.Int(60),
 * 				MaintenanceWindowStartingHour: pulumi.Int(2),
 * 			},
 * 			KeyVaultCredentialSettings: &sqlvirtualmachine.KeyVaultCredentialSettingsArgs{
 * 				Enable: pulumi.Bool(false),
 * 			},
 * 			Location:          pulumi.String("northeurope"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerConfigurationsManagementSettings: sqlvirtualmachine.ServerConfigurationsManagementSettingsResponse{
 * 				AdditionalFeaturesServerConfigurations: &sqlvirtualmachine.AdditionalFeaturesServerConfigurationsArgs{
 * 					IsRServicesEnabled: pulumi.Bool(false),
 * 				},
 * 				SqlConnectivityUpdateSettings: &sqlvirtualmachine.SqlConnectivityUpdateSettingsArgs{
 * 					ConnectivityType:      pulumi.String("PRIVATE"),
 * 					Port:                  pulumi.Int(1433),
 * 					SqlAuthUpdatePassword: pulumi.String("<password>"),
 * 					SqlAuthUpdateUserName: pulumi.String("sqllogin"),
 * 				},
 * 				SqlInstanceSettings: &sqlvirtualmachine.SQLInstanceSettingsArgs{
 * 					Collation:                          pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 					IsIfiEnabled:                       pulumi.Bool(true),
 * 					IsLpimEnabled:                      pulumi.Bool(true),
 * 					IsOptimizeForAdHocWorkloadsEnabled: pulumi.Bool(true),
 * 					MaxDop:                             pulumi.Int(8),
 * 					MaxServerMemoryMB:                  pulumi.Int(128),
 * 					MinServerMemoryMB:                  pulumi.Int(0),
 * 				},
 * 				SqlStorageUpdateSettings: &sqlvirtualmachine.SqlStorageUpdateSettingsArgs{
 * 					DiskConfigurationType: pulumi.String("NEW"),
 * 					DiskCount:             pulumi.Int(1),
 * 					StartingDeviceId:      pulumi.Int(2),
 * 				},
 * 				SqlWorkloadTypeUpdateSettings: &sqlvirtualmachine.SqlWorkloadTypeUpdateSettingsArgs{
 * 					SqlWorkloadType: pulumi.String("OLTP"),
 * 				},
 * 			},
 * 			SqlImageSku:              pulumi.String("Enterprise"),
 * 			SqlManagement:            pulumi.String("Full"),
 * 			SqlServerLicenseType:     pulumi.String("PAYG"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .assessmentSettings(Map.ofEntries(
 *                 Map.entry("enable", true),
 *                 Map.entry("runImmediately", true),
 *                 Map.entry("schedule", Map.ofEntries(
 *                     Map.entry("dayOfWeek", "Sunday"),
 *                     Map.entry("enable", true),
 *                     Map.entry("startTime", "23:17"),
 *                     Map.entry("weeklyInterval", 1)
 *                 ))
 *             ))
 *             .autoBackupSettings(Map.ofEntries(
 *                 Map.entry("backupScheduleType", "Manual"),
 *                 Map.entry("backupSystemDbs", true),
 *                 Map.entry("enable", true),
 *                 Map.entry("enableEncryption", true),
 *                 Map.entry("fullBackupFrequency", "Daily"),
 *                 Map.entry("fullBackupStartTime", 6),
 *                 Map.entry("fullBackupWindowHours", 11),
 *                 Map.entry("logBackupFrequency", 10),
 *                 Map.entry("password", "<Password>"),
 *                 Map.entry("retentionPeriod", 17),
 *                 Map.entry("storageAccessKey", "<primary storage access key>"),
 *                 Map.entry("storageAccountUrl", "https://teststorage.blob.core.windows.net/"),
 *                 Map.entry("storageContainerName", "testcontainer")
 *             ))
 *             .autoPatchingSettings(Map.ofEntries(
 *                 Map.entry("dayOfWeek", "Sunday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("maintenanceWindowDuration", 60),
 *                 Map.entry("maintenanceWindowStartingHour", 2)
 *             ))
 *             .keyVaultCredentialSettings(Map.of("enable", false))
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .serverConfigurationsManagementSettings(Map.ofEntries(
 *                 Map.entry("additionalFeaturesServerConfigurations", Map.of("isRServicesEnabled", false)),
 *                 Map.entry("sqlConnectivityUpdateSettings", Map.ofEntries(
 *                     Map.entry("connectivityType", "PRIVATE"),
 *                     Map.entry("port", 1433),
 *                     Map.entry("sqlAuthUpdatePassword", "<password>"),
 *                     Map.entry("sqlAuthUpdateUserName", "sqllogin")
 *                 )),
 *                 Map.entry("sqlInstanceSettings", Map.ofEntries(
 *                     Map.entry("collation", "SQL_Latin1_General_CP1_CI_AS"),
 *                     Map.entry("isIfiEnabled", true),
 *                     Map.entry("isLpimEnabled", true),
 *                     Map.entry("isOptimizeForAdHocWorkloadsEnabled", true),
 *                     Map.entry("maxDop", 8),
 *                     Map.entry("maxServerMemoryMB", 128),
 *                     Map.entry("minServerMemoryMB", 0)
 *                 )),
 *                 Map.entry("sqlStorageUpdateSettings", Map.ofEntries(
 *                     Map.entry("diskConfigurationType", "NEW"),
 *                     Map.entry("diskCount", 1),
 *                     Map.entry("startingDeviceId", 2)
 *                 )),
 *                 Map.entry("sqlWorkloadTypeUpdateSettings", Map.of("sqlWorkloadType", "OLTP"))
 *             ))
 *             .sqlImageSku("Enterprise")
 *             .sqlManagement("Full")
 *             .sqlServerLicenseType("PAYG")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine with min parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:                 pulumi.String("northeurope"),
 * 			ResourceGroupName:        pulumi.String("testrg"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:SqlVirtualMachine testvm /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}
 * ```
 */
public class SqlVirtualMachine internal constructor(
    override val javaResource: com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine,
) : KotlinCustomResource(javaResource, SqlVirtualMachineMapper) {
    /**
     * Assessment Settings.
     */
    public val assessmentSettings: Output<AssessmentSettingsResponse>?
        get() = javaResource.assessmentSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> assessmentSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Auto backup settings for SQL Server.
     */
    public val autoBackupSettings: Output<AutoBackupSettingsResponse>?
        get() = javaResource.autoBackupSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> autoBackupSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Auto patching settings for applying critical security updates to SQL virtual machine.
     */
    public val autoPatchingSettings: Output<AutoPatchingSettingsResponse>?
        get() = javaResource.autoPatchingSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> autoPatchingSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Azure Active Directory identity of the server.
     */
    public val identity: Output<ResourceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key vault credential settings.
     */
    public val keyVaultCredentialSettings: Output<KeyVaultCredentialSettingsResponse>?
        get() = javaResource.keyVaultCredentialSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyVaultCredentialSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state to track the async operation status.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SQL Server configuration management settings.
     */
    public val serverConfigurationsManagementSettings:
        Output<ServerConfigurationsManagementSettingsResponse>?
        get() = javaResource.serverConfigurationsManagementSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serverConfigurationsManagementSettingsResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
     */
    public val sqlImageOffer: Output<String>?
        get() = javaResource.sqlImageOffer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL Server edition type.
     */
    public val sqlImageSku: Output<String>?
        get() = javaResource.sqlImageSku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL Server Management type.
     */
    public val sqlManagement: Output<String>?
        get() = javaResource.sqlManagement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL Server license type.
     */
    public val sqlServerLicenseType: Output<String>?
        get() = javaResource.sqlServerLicenseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
     */
    public val sqlVirtualMachineGroupResourceId: Output<String>?
        get() = javaResource.sqlVirtualMachineGroupResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Storage Configuration Settings.
     */
    public val storageConfigurationSettings: Output<StorageConfigurationSettingsResponse>?
        get() = javaResource.storageConfigurationSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageConfigurationSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * ARM Resource id of underlying virtual machine created from SQL marketplace image.
     */
    public val virtualMachineResourceId: Output<String>?
        get() = javaResource.virtualMachineResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    public val wsfcDomainCredentials: Output<WsfcDomainCredentialsResponse>?
        get() = javaResource.wsfcDomainCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> wsfcDomainCredentialsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    public val wsfcStaticIp: Output<String>?
        get() = javaResource.wsfcStaticIp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SqlVirtualMachineMapper : ResourceMapper<SqlVirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): SqlVirtualMachine = SqlVirtualMachine(
        javaResource as
            com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine,
    )
}

/**
 * @see [SqlVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlVirtualMachine].
 */
public suspend fun sqlVirtualMachine(
    name: String,
    block: suspend SqlVirtualMachineResourceBuilder.() -> Unit,
): SqlVirtualMachine {
    val builder = SqlVirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlVirtualMachine(name: String): SqlVirtualMachine {
    val builder = SqlVirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
