@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AdditionalFeaturesServerConfigurationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional SQL Server feature settings.
 * @property isRServicesEnabled Enable or disable R services (SQL 2016 onwards).
 */
public data class AdditionalFeaturesServerConfigurationsArgs(
    public val isRServicesEnabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AdditionalFeaturesServerConfigurationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AdditionalFeaturesServerConfigurationsArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AdditionalFeaturesServerConfigurationsArgs.builder()
            .isRServicesEnabled(isRServicesEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdditionalFeaturesServerConfigurationsArgs].
 */
@PulumiTagMarker
public class AdditionalFeaturesServerConfigurationsArgsBuilder internal constructor() {
    private var isRServicesEnabled: Output<Boolean>? = null

    /**
     * @param value Enable or disable R services (SQL 2016 onwards).
     */
    @JvmName("byknxnybcjvrgsvd")
    public suspend fun isRServicesEnabled(`value`: Output<Boolean>) {
        this.isRServicesEnabled = value
    }

    /**
     * @param value Enable or disable R services (SQL 2016 onwards).
     */
    @JvmName("wkpmysjjywvfugyi")
    public suspend fun isRServicesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRServicesEnabled = mapped
    }

    internal fun build(): AdditionalFeaturesServerConfigurationsArgs =
        AdditionalFeaturesServerConfigurationsArgs(
            isRServicesEnabled = isRServicesEnabled,
        )
}
